/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.trainControls;

import com.mojang.blaze3d.platform.InputConstants;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsInputPacket;
import com.simibubi.create.foundation.utility.ControlsUtil;
import com.simibubi.create.foundation.utility.Lang;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class ControlsHandler {
    public static Collection<Integer> currentlyPressed = new HashSet<Integer>();
    public static int PACKET_RATE = 5;
    private static int packetCooldown;
    private static WeakReference<AbstractContraptionEntity> entityRef;
    private static BlockPos controlsPos;

    public static void levelUnloaded(LevelAccessor level) {
        packetCooldown = 0;
        entityRef = new WeakReference<Object>(null);
        controlsPos = null;
        currentlyPressed.clear();
    }

    public static void startControlling(AbstractContraptionEntity entity, BlockPos controllerLocalPos) {
        entityRef = new WeakReference<AbstractContraptionEntity>(entity);
        controlsPos = controllerLocalPos;
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Lang.translateDirect("contraption.controls.start_controlling", entity.getContraptionName()), true);
    }

    public static void stopControlling() {
        ControlsUtil.getControls().forEach(kb -> kb.m_7249_(ControlsUtil.isActuallyPressed(kb)));
        AbstractContraptionEntity abstractContraptionEntity = (AbstractContraptionEntity)((Object)entityRef.get());
        if (!currentlyPressed.isEmpty() && abstractContraptionEntity != null) {
            AllPackets.getChannel().sendToServer((Object)new ControlsInputPacket(currentlyPressed, false, abstractContraptionEntity.m_19879_(), controlsPos, false));
        }
        packetCooldown = 0;
        entityRef = new WeakReference<Object>(null);
        controlsPos = null;
        currentlyPressed.clear();
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Lang.translateDirect("contraption.controls.stop_controlling", new Object[0]), true);
    }

    public static void tick() {
        AbstractContraptionEntity entity = (AbstractContraptionEntity)((Object)entityRef.get());
        if (entity == null) {
            return;
        }
        if (packetCooldown > 0) {
            --packetCooldown;
        }
        if (entity.m_213877_() || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)256)) {
            BlockPos pos = controlsPos;
            ControlsHandler.stopControlling();
            AllPackets.getChannel().sendToServer((Object)new ControlsInputPacket(currentlyPressed, false, entity.m_19879_(), pos, true));
            return;
        }
        Vector<KeyMapping> controls = ControlsUtil.getControls();
        HashSet<Integer> pressedKeys = new HashSet<Integer>();
        for (int i = 0; i < controls.size(); ++i) {
            if (!ControlsUtil.isActuallyPressed(controls.get(i))) continue;
            pressedKeys.add(i);
        }
        HashSet<Integer> newKeys = new HashSet<Integer>(pressedKeys);
        Collection<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);
        if (!releasedKeys.isEmpty()) {
            AllPackets.getChannel().sendToServer((Object)new ControlsInputPacket(releasedKeys, false, entity.m_19879_(), controlsPos, false));
        }
        if (!newKeys.isEmpty()) {
            AllPackets.getChannel().sendToServer((Object)new ControlsInputPacket(newKeys, true, entity.m_19879_(), controlsPos, false));
            packetCooldown = PACKET_RATE;
        }
        if (packetCooldown == 0) {
            AllPackets.getChannel().sendToServer((Object)new ControlsInputPacket(pressedKeys, true, entity.m_19879_(), controlsPos, false));
            packetCooldown = PACKET_RATE;
        }
        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.m_7249_(false));
    }

    @Nullable
    public static AbstractContraptionEntity getContraption() {
        return (AbstractContraptionEntity)((Object)entityRef.get());
    }

    @Nullable
    public static BlockPos getControlsPos() {
        return controlsPos;
    }

    static {
        entityRef = new WeakReference<Object>(null);
    }
}

