/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items.vehicles;

import earth.terrarium.adastra.common.items.rendered.RenderedItem;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedItemFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public abstract class VehicleItem
extends RenderedItem
implements BotariumFluidItem<WrappedItemFluidContainer> {
    private final Supplier<EntityType<?>> type;

    public VehicleItem(Supplier<EntityType<?>> type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public EntityType<?> type() {
        return this.type.get();
    }

    public WrappedItemFluidContainer getFluidContainer(ItemStack holder) {
        return new WrappedItemFluidContainer(holder, (FluidContainer)new SimpleFluidContainer(FluidConstants.fromMillibuckets((long)3000L), 1, (t, f) -> f.is(ModFluidTags.FUEL)));
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return FluidUtils.hasFluid(stack);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        WrappedItemFluidContainer fluidContainer = this.getFluidContainer(stack);
        return (int)((double)fluidContainer.getFirstFluid().getFluidAmount() / (double)fluidContainer.getTankCapacity(0) * 13.0);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return ClientFluidHooks.getFluidColor((FluidHolder)FluidUtils.getTank(stack));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add(TooltipUtils.getFluidComponent(FluidUtils.getTank(stack), FluidUtils.getTankCapacity(stack), (Fluid)ModFluids.FUEL.get()));
    }
}

