/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blocks.machines;

import earth.terrarium.adastra.common.blockentities.machines.OxygenDistributorBlockEntity;
import earth.terrarium.adastra.common.blocks.base.SidedMachineBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OxygenDistributorBlock
extends SidedMachineBlock {
    public static final VoxelShape BOTTOM_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0), (VoxelShape)Block.m_49796_((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape TOP_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)11.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape NORTH_SIDE_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)11.0, (double)15.0, (double)15.0, (double)16.0), (VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)11.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape EAST_SIDE_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)5.0, (double)15.0, (double)15.0), (VoxelShape)Block.m_49796_((double)5.0, (double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape SOUTH_SIDE_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)5.0), (VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)12.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape WEST_SIDE_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)11.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (VoxelShape)Block.m_49796_((double)1.0, (double)4.0, (double)4.0, (double)11.0, (double)12.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);

    public OxygenDistributorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((AttachFace)state.m_61143_((Property)FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> BOTTOM_SHAPE;
            case AttachFace.CEILING -> TOP_SHAPE;
            case AttachFace.WALL -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: {
                        yield NORTH_SIDE_SHAPE;
                    }
                    case EAST: {
                        yield EAST_SIDE_SHAPE;
                    }
                    case SOUTH: {
                        yield SOUTH_SIDE_SHAPE;
                    }
                    case WEST: {
                        yield WEST_SIDE_SHAPE;
                    }
                }
                yield Shapes.m_83144_();
            }
        };
    }

    @Override
    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof OxygenDistributorBlockEntity) {
            OxygenDistributorBlockEntity entity = (OxygenDistributorBlockEntity)blockEntity;
            return entity.distributedBlocksCount() / Math.max(1, entity.distributedBlocksLimit()) * 15;
        }
        return 0;
    }
}

