/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public class JSONUtil {
    public static List<JsonArray> loadAllJsonFromConfig(String subfolder) {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("NuclearCraft").resolve(subfolder);
        ArrayList<JsonArray> jsonArrayList = new ArrayList<JsonArray>();
        File[] jsonFiles = configDir.toFile().listFiles((dir, name) -> name.toLowerCase().endsWith(".json"));
        if (jsonFiles == null || jsonFiles.length == 0) {
            System.err.println("No JSON files found in config directory.");
            return null;
        }
        for (File jsonFile : jsonFiles) {
            try (FileReader reader = new FileReader(jsonFile);){
                JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                if (jsonElement.isJsonArray()) {
                    jsonArrayList.add(jsonElement.getAsJsonArray());
                    continue;
                }
                System.err.println("File " + jsonFile.getName() + " does not contain a JSON array.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return jsonArrayList;
    }
}

