/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import igentuman.nc.NuclearCraft;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.recipes.type.EmptyRecipe;
import igentuman.nc.recipes.type.NcRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class NcRecipeSerializer<RECIPE extends NcRecipe>
implements RecipeSerializer<RECIPE> {
    final IFactory<RECIPE> factory;

    public NcRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    protected FluidStackIngredient[] inputFluidsFromJson(JsonObject json, ResourceLocation recipeId) {
        FluidStackIngredient[] inputFluids;
        block7: {
            inputFluids = new FluidStackIngredient[]{};
            if (!json.has("inputFluids")) break block7;
            if (GsonHelper.m_13885_((JsonObject)json, (String)"inputFluids")) {
                JsonArray input = GsonHelper.m_13933_((JsonObject)json, (String)"inputFluids");
                inputFluids = new FluidStackIngredient[input.getAsJsonArray().size()];
                int i = 0;
                for (JsonElement in : input.getAsJsonArray()) {
                    try {
                        inputFluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize(in);
                    }
                    catch (Exception ex) {
                        NuclearCraft.LOGGER.warn("Unable to parse input fluid for recipe: " + recipeId);
                        inputFluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().from(FluidStack.EMPTY);
                    }
                    ++i;
                }
            } else {
                JsonObject inputJson = GsonHelper.m_13930_((JsonObject)json, (String)"inputFluids");
                try {
                    inputFluids = new FluidStackIngredient[]{(FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)inputJson)};
                }
                catch (Exception ex) {
                    NuclearCraft.LOGGER.warn("Unable to parse input fluid for recipe: " + recipeId);
                    inputFluids[0] = (FluidStackIngredient)IngredientCreatorAccess.fluid().from(FluidStack.EMPTY);
                }
            }
        }
        return inputFluids;
    }

    protected FluidStackIngredient[] outputFluidsFromJson(JsonObject json, ResourceLocation recipeId) {
        FluidStackIngredient[] outputFluids;
        block7: {
            outputFluids = new FluidStackIngredient[]{};
            if (!json.has("outputFluids")) break block7;
            if (GsonHelper.m_13885_((JsonObject)json, (String)"outputFluids")) {
                JsonArray output = GsonHelper.m_13933_((JsonObject)json, (String)"outputFluids");
                outputFluids = new FluidStackIngredient[output.getAsJsonArray().size()];
                int i = 0;
                for (JsonElement out : output.getAsJsonArray()) {
                    try {
                        outputFluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)out.getAsJsonObject());
                    }
                    catch (Exception ex) {
                        NuclearCraft.LOGGER.warn("Unable to parse output fluid for recipe: " + recipeId);
                        outputFluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().from(FluidStack.EMPTY);
                    }
                    ++i;
                }
            } else {
                JsonObject output = GsonHelper.m_13930_((JsonObject)json, (String)"outputFluids");
                try {
                    outputFluids = new FluidStackIngredient[]{(FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)output.getAsJsonObject())};
                }
                catch (Exception ex) {
                    NuclearCraft.LOGGER.warn("Unable to parse output fluid for recipe: " + recipeId);
                    outputFluids[0] = (FluidStackIngredient)IngredientCreatorAccess.fluid().from(FluidStack.EMPTY);
                }
            }
        }
        return outputFluids;
    }

    protected ItemStackIngredient[] inputItemsFromJson(JsonObject json, ResourceLocation recipeId) {
        ItemStackIngredient[] inputItems;
        block7: {
            inputItems = new ItemStackIngredient[]{};
            if (!json.has("input")) break block7;
            if (GsonHelper.m_13885_((JsonObject)json, (String)"input")) {
                JsonArray input = GsonHelper.m_13933_((JsonObject)json, (String)"input");
                inputItems = new ItemStackIngredient[input.getAsJsonArray().size()];
                int i = 0;
                for (JsonElement in : input.getAsJsonArray()) {
                    try {
                        inputItems[i] = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize(in);
                    }
                    catch (Exception ex) {
                        NuclearCraft.LOGGER.warn("Unable to parse input for recipe: " + recipeId);
                        inputItems[i] = NcRecipe.getBarrier();
                    }
                    ++i;
                }
            } else {
                JsonObject inputJson = GsonHelper.m_13930_((JsonObject)json, (String)"input");
                try {
                    inputItems = new ItemStackIngredient[]{(ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)inputJson)};
                }
                catch (Exception ex) {
                    NuclearCraft.LOGGER.warn("Unable to parse input for recipe: " + recipeId);
                    inputItems[0] = NcRecipe.getBarrier();
                }
            }
        }
        return inputItems;
    }

    protected ItemStackIngredient[] outputItemsFromJson(JsonObject json, ResourceLocation recipeId) {
        ItemStackIngredient[] outputItems;
        block7: {
            outputItems = new ItemStackIngredient[]{};
            if (!json.has("output")) break block7;
            if (GsonHelper.m_13885_((JsonObject)json, (String)"output")) {
                JsonArray output = GsonHelper.m_13933_((JsonObject)json, (String)"output");
                outputItems = new ItemStackIngredient[output.getAsJsonArray().size()];
                int i = 0;
                for (JsonElement out : output.getAsJsonArray()) {
                    try {
                        outputItems[i] = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize(out);
                    }
                    catch (JsonSyntaxException ex) {
                        NuclearCraft.LOGGER.error("Error parsing output itemstack for recipe: " + recipeId.toString());
                        outputItems[i] = NcRecipe.getBarrier();
                    }
                    ++i;
                }
            } else {
                JsonObject output = GsonHelper.m_13930_((JsonObject)json, (String)"output");
                try {
                    outputItems = new ItemStackIngredient[]{(ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)output.getAsJsonObject())};
                }
                catch (Exception ex) {
                    NuclearCraft.LOGGER.warn("Unable to parse output for recipe: " + recipeId);
                    outputItems[0] = NcRecipe.getBarrier();
                }
            }
        }
        return outputItems;
    }

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        String type = GsonHelper.m_13906_((JsonObject)json, (String)"type");
        if (Processors.all().containsKey(type) && !Processors.all().get(type).config().isRegistered()) {
            return this.emptyRecipe(recipeId);
        }
        ItemStackIngredient[] inputItems = this.inputItemsFromJson(json, recipeId);
        ItemStackIngredient[] outputItems = this.outputItemsFromJson(json, recipeId);
        FluidStackIngredient[] inputFluids = this.inputFluidsFromJson(json, recipeId);
        FluidStackIngredient[] outputFluids = this.outputFluidsFromJson(json, recipeId);
        double timeModifier = 1.0;
        double powerModifier = 1.0;
        double radiation = 1.0;
        double rarityModifier = 1.0;
        double temperature = 1.0;
        try {
            timeModifier = GsonHelper.m_144742_((JsonObject)json, (String)"timeModifier", (double)1.0);
            powerModifier = GsonHelper.m_144742_((JsonObject)json, (String)"powerModifier", (double)1.0);
            radiation = GsonHelper.m_144742_((JsonObject)json, (String)"radiation", (double)1.0);
            rarityModifier = GsonHelper.m_144742_((JsonObject)json, (String)"rarityModifier", (double)1.0);
            temperature = GsonHelper.m_144742_((JsonObject)json, (String)"temperature", (double)1.0);
            if (temperature > 1.0) {
                rarityModifier = temperature;
            }
        }
        catch (Exception ex) {
            NuclearCraft.LOGGER.warn("Unable to parse params for recipe: " + recipeId);
        }
        return this.factory.create(recipeId, inputItems, outputItems, inputFluids, outputFluids, timeModifier, powerModifier, radiation, rarityModifier);
    }

    RECIPE emptyRecipe(@NotNull ResourceLocation recipeId) {
        return (RECIPE)new EmptyRecipe(recipeId);
    }

    public ItemStackIngredient[] readItems(@NotNull FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ItemStackIngredient[] items = new ItemStackIngredient[size];
        for (int i = 0; i < size; ++i) {
            items[i] = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        }
        return items;
    }

    public FluidStackIngredient[] readFluids(@NotNull FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        FluidStackIngredient[] fluids = new FluidStackIngredient[size];
        for (int i = 0; i < size; ++i) {
            fluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
        }
        return fluids;
    }

    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient[] inputItems = this.readItems(buffer);
            ItemStackIngredient[] outputItems = this.readItems(buffer);
            FluidStackIngredient[] inputFluids = this.readFluids(buffer);
            FluidStackIngredient[] outputFluids = this.readFluids(buffer);
            double timeModifier = buffer.readDouble();
            double powerModifier = buffer.readDouble();
            double radiation = buffer.readDouble();
            return this.factory.create(recipeId, inputItems, outputItems, inputFluids, outputFluids, timeModifier, powerModifier, radiation, 1.0);
        }
        catch (Exception e) {
            NuclearCraft.LOGGER.error("Error reading recipe {} from packet. Trace: {}", (Object)recipeId, (Object)e);
            NuclearCraft.LOGGER.error("Return empty recipe for: {}", (Object)recipeId);
            return this.emptyRecipe(recipeId);
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((NcRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            NuclearCraft.LOGGER.error("Error writing recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends NcRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient[] var2, ItemStackIngredient[] var3, FluidStackIngredient[] var4, FluidStackIngredient[] var5, double var6, double var8, double var10, double var12);
    }
}

