/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes;

import igentuman.nc.client.NcClient;
import igentuman.nc.recipes.AbstractRecipe;
import java.util.NoSuchElementException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RecipeInfo<RECIPE extends AbstractRecipe>
implements INBTSerializable<Tag> {
    public int ticks = 0;
    public double ticksProcessed = 0.0;
    public double energy = 0.0;
    public double heat = 0.0;
    public double radiation = 0.0;
    public boolean stuck = false;
    public RECIPE recipe;
    public BlockEntity be;
    private String recipeId;

    public void setRecipe(RECIPE recipe) {
        this.recipe = recipe;
        this.recipeId = ((AbstractRecipe)recipe).m_6423_().toString();
    }

    public boolean isCompleted() {
        return this.ticksProcessed >= (double)this.ticks && this.ticks != 0;
    }

    public Tag serializeNBT() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("ticks", this.ticks);
        data.m_128347_("ticksProcessed", this.ticksProcessed);
        data.m_128347_("energy", this.energy);
        data.m_128347_("heat", this.heat);
        data.m_128347_("radiation", this.radiation);
        data.m_128379_("stuck", this.stuck);
        if (this.recipe != null) {
            data.m_128359_("recipe", this.recipeId);
        }
        return data;
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            this.ticks = ((CompoundTag)nbt).m_128451_("ticks");
            this.ticksProcessed = ((CompoundTag)nbt).m_128459_("ticksProcessed");
            this.energy = ((CompoundTag)nbt).m_128459_("energy");
            this.heat = ((CompoundTag)nbt).m_128459_("heat");
            this.radiation = ((CompoundTag)nbt).m_128459_("radiation");
            this.stuck = ((CompoundTag)nbt).m_128471_("stuck");
            this.recipeId = ((CompoundTag)nbt).m_128461_("recipe");
            this.recipe = null;
            if (!this.recipeId.isEmpty()) {
                this.recipe = this.getRecipeFromTag(this.recipeId);
            }
        }
    }

    private Level getLevel() {
        if (this.be != null) {
            return this.be.m_58904_();
        }
        return (Level)DistExecutor.unsafeRunForDist(() -> NcClient::tryGetClientWorld, () -> () -> ServerLifecycleHooks.getCurrentServer().m_129783_());
    }

    private RECIPE getRecipeFromTag(String recipe) {
        ResourceLocation id = new ResourceLocation(recipe);
        if (this.getLevel() == null) {
            return null;
        }
        try {
            return (RECIPE)((AbstractRecipe)this.getLevel().m_7465_().m_44043_(id).get());
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public double getProgress() {
        if (this.ticks > 0) {
            return this.ticksProcessed / (double)this.ticks;
        }
        return 0.0;
    }

    public boolean process(double multiplier) {
        if (this.isStuck()) {
            return false;
        }
        if (Double.isNaN(this.ticksProcessed)) {
            this.ticksProcessed = 0.0;
        }
        this.ticksProcessed += 1.0 * Math.abs(multiplier);
        this.ticksProcessed = Math.min((double)this.ticks, this.ticksProcessed);
        return true;
    }

    public void clear() {
        this.recipe = null;
        this.recipeId = "";
        this.ticks = 0;
        this.heat = 0.0;
        this.energy = 0.0;
        this.radiation = 0.0;
        this.stuck = false;
        this.ticksProcessed = 0.0;
    }

    public boolean isStuck() {
        return this.stuck;
    }

    public RECIPE recipe() {
        if (this.recipe == null && this.recipeId != null && !this.recipeId.isEmpty()) {
            this.recipe = this.getRecipeFromTag(this.recipeId);
        }
        return this.recipe;
    }
}

