/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.radiation.data;

import igentuman.nc.radiation.data.PlayerRadiation;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class PlayerRadiationProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<PlayerRadiation> PLAYER_RADIATION = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerRadiation>(){});
    private PlayerRadiation playerRadiation = this.createPlayerRadiation();
    private final LazyOptional<PlayerRadiation> opt = LazyOptional.of(this::createPlayerRadiation);

    public static void setRadiation(Player pl, int i) {
        PlayerRadiation playerRadiationCap = (PlayerRadiation)pl.getCapability(PLAYER_RADIATION).orElse(null);
        if (playerRadiationCap != null) {
            playerRadiationCap.setRadiation(i);
        }
    }

    @Nonnull
    private PlayerRadiation createPlayerRadiation() {
        if (this.playerRadiation == null) {
            this.playerRadiation = new PlayerRadiation();
        }
        return this.playerRadiation;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == PLAYER_RADIATION) {
            return this.opt.cast();
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    public CompoundTag serializeNBT() {
        return this.playerRadiation.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.playerRadiation.deserializeNBT(nbt);
    }
}

