/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.turbine;

import igentuman.nc.block.entity.turbine.TurbineBladeBE;
import igentuman.nc.block.entity.turbine.TurbineCoilBE;
import igentuman.nc.block.entity.turbine.TurbineControllerBE;
import igentuman.nc.block.entity.turbine.TurbineRotorBE;
import igentuman.nc.block.turbine.TurbineBearingBlock;
import igentuman.nc.block.turbine.TurbineBladeBlock;
import igentuman.nc.block.turbine.TurbineRotorBlock;
import igentuman.nc.handler.config.TurbineConfig;
import igentuman.nc.multiblock.AbstractNCMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.turbine.TurbineController;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.util.NCBlockPos;
import igentuman.nc.util.TagUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TurbineMultiblock
extends AbstractNCMultiblock {
    public Direction turbineDirection;
    public boolean isRotorValid = false;
    public List<BlockPos> bearingPositions = new ArrayList<BlockPos>();
    public List<BlockPos> rotorPositions = new ArrayList<BlockPos>();
    public List<BlockPos> coilPositions = new ArrayList<BlockPos>();
    public float flow = 0.0f;
    public int activeCoils = 0;
    public double coilsEfficiency = 0.0;
    public int blades = 0;
    private List<BlockPos> bladePositions = new ArrayList<BlockPos>();

    @Override
    public int maxHeight() {
        return (Integer)TurbineConfig.TURBINE_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int maxWidth() {
        return (Integer)TurbineConfig.TURBINE_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int maxDepth() {
        return (Integer)TurbineConfig.TURBINE_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int minHeight() {
        return (Integer)TurbineConfig.TURBINE_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int minWidth() {
        return (Integer)TurbineConfig.TURBINE_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int minDepth() {
        return (Integer)TurbineConfig.TURBINE_CONFIG.MIN_SIZE.get();
    }

    public TurbineMultiblock(TurbineControllerBE<?> turbineControllerBE) {
        super(TagUtil.getBlocksByTagKey(TurbineRegistration.CASING_BLOCKS.f_203868_().toString()), TagUtil.getBlocksByTagKey(TurbineRegistration.INNER_TURBINE_BLOCKS.f_203868_().toString()));
        this.id = "turbine_" + turbineControllerBE.m_58899_().m_123344_();
        MultiblockHandler.addMultiblock(this);
        this.controller = new TurbineController(turbineControllerBE);
    }

    @Override
    public List<Block> validCornerBlocks() {
        return List.of((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_casing").get());
    }

    @Override
    public void validateInner() {
        if (!this.outerValid) {
            return;
        }
        super.validateInner();
        this.detectOrientation();
        this.isRotorValid = this.validateRotor();
        if (!this.isRotorValid) {
            this.validationResult = ValidationResult.WRONG_INNER;
        }
    }

    @Override
    public void validate() {
        this.coilPositions.clear();
        this.rotorPositions.clear();
        this.bearingPositions.clear();
        this.bladePositions.clear();
        super.validate();
        if (!this.validateProportions()) {
            this.validationResult = ValidationResult.WRONG_PROPORTIONS;
            this.innerValid = false;
            this.outerValid = false;
            this.isFormed = false;
        } else {
            this.countCoils();
            this.countBlades();
            if (this.blades % 4 != 0) {
                this.validationResult = ValidationResult.WRONG_BLADES;
                this.innerValid = false;
                this.outerValid = false;
                this.isFormed = false;
            }
        }
    }

    private void countBlades() {
        this.flow = 0.0f;
        this.blades = 0;
        for (BlockPos pos : this.bladePositions) {
            TurbineBladeBE blade;
            BlockEntity be = this.getBlockEntity(pos);
            if (!(be instanceof TurbineBladeBE) || !(blade = (TurbineBladeBE)be).isValid()) continue;
            this.flow += blade.getFlow();
            ++this.blades;
        }
    }

    private void detectOrientation() {
        if (this.rotorPositions.isEmpty()) {
            return;
        }
        BlockPos rotorPos = this.rotorPositions.get(0);
        BlockState st = this.getBlockState(rotorPos);
        this.turbineDirection = (Direction)st.m_61143_((Property)TurbineRotorBlock.f_52588_);
    }

    @Override
    public void tick() {
        super.tick();
        TurbineControllerBE controller = (TurbineControllerBE)this.controller().controllerBE();
    }

    @Override
    protected boolean processInnerBlock(BlockPos toCheck) {
        BlockState bs = this.getBlockState(toCheck);
        if (bs.m_60795_()) {
            return true;
        }
        super.processInnerBlock(new NCBlockPos((Vec3i)toCheck));
        if (bs.m_60734_() instanceof TurbineRotorBlock) {
            this.rotorPositions.add(new NCBlockPos((Vec3i)toCheck));
        }
        if (bs.m_60734_() instanceof TurbineBladeBlock) {
            this.bladePositions.add(new NCBlockPos((Vec3i)toCheck));
        }
        return true;
    }

    @Override
    protected void processOuterBlock(BlockPos pos) {
        super.processOuterBlock(pos);
        BlockEntity be = this.getBlockEntity(pos);
        BlockState bs = this.getBlockState(pos);
        if (bs.m_60734_() instanceof TurbineBearingBlock) {
            this.bearingPositions.add(new NCBlockPos((Vec3i)pos));
        }
        if (be instanceof TurbineCoilBE) {
            this.coilPositions.add(new NCBlockPos((Vec3i)pos));
        }
    }

    public void countCoils() {
        this.activeCoils = 0;
        this.coilsEfficiency = 0.0;
        for (BlockPos pos : this.coilPositions) {
            BlockEntity be = this.getBlockEntity(pos);
            if (!(be instanceof TurbineCoilBE)) continue;
            TurbineCoilBE coil = (TurbineCoilBE)be;
            coil.validatePlacement();
            if (this.coilsEfficiency == 0.0) {
                this.coilsEfficiency = coil.getRealEfficiency();
            }
            this.coilsEfficiency = (this.coilsEfficiency + coil.getRealEfficiency()) / 2.0;
            this.activeCoils += coil.isValid() ? 1 : 0;
        }
    }

    public boolean validateProportions() {
        if (this.turbineDirection == null || this.bearingPositions.size() != 2) {
            return false;
        }
        switch (this.turbineDirection) {
            case UP: 
            case DOWN: {
                return this.width() == this.depth() && this.width() % 2 != 0;
            }
            case NORTH: 
            case SOUTH: {
                if (this.getFacing().m_122434_().equals((Object)Direction.Axis.Z)) {
                    return this.height() == this.width() && this.height() % 2 != 0;
                }
                return this.depth() == this.height() && this.height() % 2 != 0;
            }
            case EAST: 
            case WEST: {
                if (this.getFacing().m_122434_().equals((Object)Direction.Axis.X)) {
                    return this.height() == this.width() && this.height() % 2 != 0;
                }
                return this.height() == this.depth() && this.height() % 2 != 0;
            }
        }
        return false;
    }

    public boolean validateRotor() {
        if (this.rotorPositions.isEmpty()) {
            return false;
        }
        boolean bearingConnected = true;
        Direction dir = this.turbineDirection;
        for (BlockPos pos : this.rotorPositions) {
            BlockState bs = this.getBlockState(pos);
            if (!(bs.m_60734_() instanceof TurbineRotorBlock)) {
                return false;
            }
            if (bs.m_61143_((Property)TurbineRotorBlock.f_52588_) != dir) {
                return false;
            }
            switch (dir) {
                case UP: 
                case DOWN: {
                    if (pos.m_123343_() == this.rotorPositions.get(0).m_123343_() && pos.m_123341_() == this.rotorPositions.get(0).m_123341_()) break;
                    return false;
                }
                case NORTH: 
                case SOUTH: {
                    if (pos.m_123342_() == this.rotorPositions.get(0).m_123342_() && pos.m_123341_() == this.rotorPositions.get(0).m_123341_()) break;
                    return false;
                }
                case EAST: 
                case WEST: {
                    if (pos.m_123342_() == this.rotorPositions.get(0).m_123342_() && pos.m_123343_() == this.rotorPositions.get(0).m_123343_()) break;
                    return false;
                }
            }
            BlockEntity be = this.getBlockEntity(pos);
            if (!(be instanceof TurbineRotorBE)) {
                return false;
            }
            TurbineRotorBE rotorBE = (TurbineRotorBE)be;
            rotorBE.updateBearingConnection();
            bearingConnected = bearingConnected && rotorBE.connectedToBearing;
        }
        return bearingConnected && this.getBlockEntity(this.getCenterBlock()) instanceof TurbineRotorBE;
    }

    @Override
    public void invalidateStats() {
        this.controller().clearStats();
    }

    @Override
    protected Direction getFacing() {
        return ((TurbineControllerBE)this.controller().controllerBE()).getFacing();
    }
}

