/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.fission;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.fission.FissionFuelCellBlock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.fission.FissionReactor;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.util.TagUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class HeatSinkDef {
    public double heat = 0.0;
    public String name = "";
    public String[] rules;
    protected Validator validator;
    private boolean initialized = false;

    public static HeatSinkDef of(JsonObject asJsonObject) {
        HeatSinkDef def = new HeatSinkDef();
        try {
            def.heat = asJsonObject.get("heat").getAsDouble();
            def.name = asJsonObject.get("type").getAsString();
            JsonArray rules = asJsonObject.getAsJsonArray("placement_rule");
            String[] ruleArray = new String[rules.size()];
            for (int i = 0; i < rules.size(); ++i) {
                ruleArray[i] = rules.get(i).getAsString();
            }
            def.rules = ruleArray;
            return def;
        }
        catch (Exception e) {
            NuclearCraft.LOGGER.error("Error parsing heatsink definition: " + e.getMessage());
            return null;
        }
    }

    public Validator getValidator() {
        if (this.validator == null) {
            this.initCondition(this.rules);
        }
        return this.validator;
    }

    private HeatSinkDef() {
    }

    private void initCondition(String[] rules) {
        HashMap<String[], List<String>> conditions = new HashMap<String[], List<String>>();
        for (String rule : rules) {
            int cnt = 1;
            try {
                cnt = Math.max(Integer.parseInt(rule.substring(rule.length() - 1)), 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String[] conditionParts = rule.split("=|-|>|<|\\^");
            String[] blocks = conditionParts[0].split("\\|");
            List<String> actualBlocks = this.collectBlocks(blocks);
            conditions.put(new String[]{this.getConditionFunc(rule), String.valueOf(cnt), rule}, actualBlocks);
        }
        this.validator = new Validator();
        this.validator.blockLines = conditions;
    }

    private String getConditionFunc(String rule) {
        Pattern func = Pattern.compile("=|-|>|<|\\^");
        Matcher matcher = func.matcher(rule);
        ArrayList<String> matches = new ArrayList<String>();
        String funcType = ">";
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        if (!matches.isEmpty()) {
            funcType = (String)matches.get(0);
        }
        return funcType;
    }

    public List<String> getItemsByTagKey(String key) {
        ArrayList<String> tmp = new ArrayList<String>();
        TagKey tag = TagKey.m_203882_(Registries.ITEM_REGISTRY, (ResourceLocation)new ResourceLocation(key));
        Ingredient ing = Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(tag)));
        for (ItemStack item : ing.m_43908_()) {
            tmp.add(item.m_41720_().toString());
        }
        return tmp;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> collectBlocks(String[] blocks) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (String string : blocks) {
            void var6_6;
            if (string.contains("#")) {
                tmp.addAll(this.getItemsByTagKey(string.replace("#", "")));
                continue;
            }
            if (!string.contains(":")) {
                String string2 = "nuclearcraft:" + string;
            }
            tmp.add((String)var6_6);
        }
        return tmp;
    }

    public double getHeat() {
        return this.heat;
    }

    public boolean mustdDirectlyTouchFuelCell() {
        return this.validator.hasToTouchFuelCell();
    }

    public List<FluidStack> getAllowedFluids() {
        return this.getFluidByTagKey("forge:" + this.name);
    }

    private List<FluidStack> getFluidByTagKey(String name) {
        ArrayList<FluidStack> tmp = new ArrayList<FluidStack>();
        Fluid fluid = TagUtil.getFirstMatchingFluidByTag(name);
        tmp.add(new FluidStack(fluid, 1));
        return tmp;
    }

    public static class Validator {
        private HashMap<String[], List<String>> blockLines = new HashMap();
        private HashMap<String[], List<Block>> blocks = new HashMap();

        public boolean isValid(Level level, BlockPos pos) {
            boolean result = false;
            BlockPos p = new BlockPos((Vec3i)pos);
            for (String[] condition : this.blocks().keySet()) {
                if (result = (switch (condition[0]) {
                    case ">" -> this.isMoreThan(Integer.parseInt(condition[1]), condition, level, p);
                    case "<" -> this.isLessThan(Integer.parseInt(condition[1]), condition, level, p);
                    case "-" -> this.isBetween(condition, level, p);
                    case "=" -> this.isExact(Integer.parseInt(condition[1]), condition, level, p);
                    case "^" -> this.inCorner(Integer.parseInt(condition[1]), condition, level, p);
                    default -> result;
                })) continue;
                return false;
            }
            return result;
        }

        public boolean validateFuelCellAttachment(Level level, BlockPos ... pos) {
            for (BlockPos p : pos) {
                for (Direction dir : Direction.values()) {
                    if (MultiblockHandler.checkAttachmentToBlock(FissionFuelCellBlock.class, level, p, dir)) {
                        return true;
                    }
                    if (!(level.m_8055_(p.m_121945_(dir)).m_60734_() instanceof FissionFuelCellBlock)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean inCorner(int qty, String[] condition, Level level, BlockPos pos) {
            int initial = this.blocks.get(condition).contains(level.m_8055_(pos.m_6630_(1)).m_60734_()) ? 1 : 0;
            initial = this.blocks.get(condition).contains(level.m_8055_(pos.m_6625_(1)).m_60734_()) ? 1 : initial;
            int[] matches = new int[4];
            int i = 0;
            for (Direction dir : List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST)) {
                if (this.blocks.get(condition).contains(level.m_8055_(pos.m_121945_(dir)).m_60734_())) {
                    if (1 + initial >= qty) {
                        return true;
                    }
                    matches[i] = 1;
                }
                ++i;
            }
            for (int k = 0; k < 4; ++k) {
                int next = k + 1;
                if (next > 3) {
                    next = 0;
                }
                if (matches[k] + matches[next] + initial < qty) continue;
                return true;
            }
            return false;
        }

        private boolean isExact(int s, String[] condition, Level level, BlockPos pos) {
            int counter = 0;
            for (Direction dir : Direction.values()) {
                if (!this.blocks.get(condition).contains(level.m_8055_(pos.m_121945_(dir)).m_60734_()) || this.mustCheckFuelCellConnection(condition) && !this.validateFuelCellAttachment(level, pos, pos.m_121945_(dir)) || ++counter <= s) continue;
                return false;
            }
            return counter == s;
        }

        private boolean isBetween(String[] condition, Level level, BlockPos pos) {
            for (Direction dir : Direction.values()) {
                if (!this.blocks.get(condition).contains(level.m_8055_(pos.m_121945_(dir)).m_60734_()) || !this.blocks.get(condition).contains(level.m_8055_(pos.m_121945_(dir.m_122424_())).m_60734_()) || !this.validateFuelCellAttachment(level, pos, pos.m_121945_(dir)) || !this.validateFuelCellAttachment(level, pos, pos.m_121945_(dir.m_122424_()))) continue;
                return true;
            }
            return false;
        }

        private boolean isLessThan(int s, String[] condition, Level level, BlockPos pos) {
            int counter = 0;
            for (Direction dir : Direction.values()) {
                if (!this.blocks.get(condition).contains(level.m_8055_(pos.m_121945_(dir)).m_60734_()) || this.mustCheckFuelCellConnection(condition) && !this.validateFuelCellAttachment(level, pos, pos.m_121945_(dir)) || ++counter < s) continue;
                return false;
            }
            return counter < s;
        }

        private boolean mustCheckFuelCellConnection(String[] condition) {
            return !condition[2].contains("casing");
        }

        private boolean isMoreThan(int s, String[] condition, Level level, BlockPos pos) {
            int counter = 0;
            for (Direction dir : Direction.values()) {
                Block target = level.m_8055_(pos.m_121945_(dir)).m_60734_();
                if (!this.blocks.get(condition).contains(target) || this.mustCheckFuelCellConnection(condition) && !this.validateFuelCellAttachment(level, pos, pos.m_121945_(dir)) || ++counter < s) continue;
                return true;
            }
            return counter >= s;
        }

        public HashMap<String[], List<String>> blockLines() {
            return this.blockLines;
        }

        /*
         * WARNING - void declaration
         */
        public HashMap<String[], List<Block>> blocks() {
            if (this.blocks.isEmpty()) {
                for (String[] condition : this.blockLines().keySet()) {
                    ArrayList<Block> tmp = new ArrayList<Block>();
                    for (String string : this.blockLines().get(condition)) {
                        void var5_5;
                        if (string.contains("#")) {
                            tmp.addAll(TagUtil.getBlocksByTagKey(string));
                            continue;
                        }
                        if (!string.contains(":")) {
                            String string2 = "nuclearcraft:" + string;
                        }
                        tmp.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)var5_5)));
                    }
                    this.blocks.put(condition, tmp);
                }
            }
            return this.blocks;
        }

        public boolean hasToTouchFuelCell() {
            for (List<Block> blockList : this.blocks().values()) {
                if (!blockList.contains(FissionReactor.FISSION_BLOCKS.get("fission_reactor_solid_fuel_cell").get()) || blockList.size() != 1) continue;
                return true;
            }
            return false;
        }
    }
}

