/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.mixin;

import igentuman.nc.NuclearCraft;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TagLoader.class})
public class TagLoaderMixin {
    @Inject(method={"load"}, at={@At(value="TAIL")}, cancellable=true, remap=false)
    private void load(CallbackInfoReturnable<Map<ResourceLocation, List<TagLoader.EntryWithSource>>> callback) {
        Map<ResourceLocation, List<TagLoader.EntryWithSource>> map = (Map<ResourceLocation, List<TagLoader.EntryWithSource>>)callback.getReturnValue();
        map = TagLoaderMixin.fixMissingFor(new ResourceLocation("mineable/pickaxe"), map);
        map = TagLoaderMixin.fixMissingFor(new ResourceLocation("needs_iron_tool"), map);
        callback.setReturnValue(map);
    }

    private static Map<ResourceLocation, List<TagLoader.EntryWithSource>> fixMissingFor(ResourceLocation type, Map<ResourceLocation, List<TagLoader.EntryWithSource>> map) {
        if (!map.containsKey(type)) {
            return map;
        }
        ArrayList<TagLoader.EntryWithSource> list = new ArrayList<TagLoader.EntryWithSource>();
        for (TagLoader.EntryWithSource entry : map.get(type)) {
            if (!((Block)ForgeRegistries.BLOCKS.getValue(entry.f_216042_().getId())).equals(Blocks.f_50016_)) {
                list.add(entry);
                continue;
            }
            NuclearCraft.LOGGER.error("Tag {} contains missing block {}", (Object)type, (Object)entry.f_216042_().getId());
        }
        map.replace(type, list);
        return map;
    }
}

