/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.config;

import igentuman.nc.content.processors.Processors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ProcessorsConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ProcessorConfig PROCESSOR_CONFIG = new ProcessorConfig(BUILDER);
    public static final InSituLeachingConfig IN_SITU_LEACHING = new InSituLeachingConfig(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    private static boolean loaded = false;
    private static List<Runnable> loadActions = new ArrayList<Runnable>();

    public static <T> List<T> toList(Collection<T> vals) {
        return new ArrayList<T>(vals);
    }

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class ProcessorConfig {
        public ForgeConfigSpec.ConfigValue<Integer> GT_AMPERAGE;
        public ForgeConfigSpec.ConfigValue<Integer> GT_SUPPORT;
        public ForgeConfigSpec.ConfigValue<Boolean> GT_EXPLODE;
        public ForgeConfigSpec.ConfigValue<Integer> BASE_TIME;
        public ForgeConfigSpec.ConfigValue<Integer> BASE_POWER;
        public ForgeConfigSpec.ConfigValue<Integer> SKIP_TICKS;
        public HashMap<String, ProcessorConfigSpec> PROCESSOR_CONFIG;

        public ProcessorConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Common settings");
            this.BASE_TIME = builder.comment("Ticks").define("base_time", (Object)240);
            this.BASE_POWER = builder.comment("FE per Tick").comment("Better use value multiple of 8").define("base_power", (Object)128);
            this.GT_AMPERAGE = builder.comment("GT EU Amperage").define("gteu_amperage", (Object)2);
            this.GT_SUPPORT = builder.comment("GT EU direct support enabled?").comment("0 - disabled, 1 - enabled EU and FE, 2 - EU only").define("gteu_support", (Object)1);
            this.GT_EXPLODE = builder.comment("Enable explosion on wrong GE EU amperage").define("gteu_explode", false);
            this.SKIP_TICKS = builder.comment("Generally used for server optimization. Processors will skip defined amount of ticks then and do nothing.").comment("This won't affect recipe production performance").comment("Let's say it will skip 2 ticks, and then it will multiply recipe progress by amount if skipped ticks.").comment("So it won't do the job each tick. But production will be the same as if it was done each tick.").comment("This only works if processor has recipe in work").comment("May lead to unknown issues, Please test first").defineInRange("skip_ticks", 0, 0, 10);
            builder.pop();
            this.PROCESSOR_CONFIG = new HashMap();
            for (String processor : Processors.all().keySet()) {
                builder.push(processor);
                this.PROCESSOR_CONFIG.put(processor, new ProcessorConfigSpec(builder, true, Processors.all().get(processor).getPower(), Processors.all().get(processor).getTime()));
                builder.pop();
            }
        }

        public static class ProcessorConfigSpec {
            public ForgeConfigSpec.ConfigValue<Boolean> register;
            public ForgeConfigSpec.ConfigValue<Integer> base_power;
            public ForgeConfigSpec.ConfigValue<Integer> base_time;

            public ProcessorConfigSpec(ForgeConfigSpec.Builder builder, boolean register, int base_power, int base_time) {
                this.register = builder.define("register", register);
                this.base_power = builder.define("base_power", (Object)base_power);
                this.base_time = builder.define("base_time", (Object)base_time);
            }
        }
    }

    public static class InSituLeachingConfig {
        public ForgeConfigSpec.ConfigValue<Boolean> ENABLE_VEINS;
        public ForgeConfigSpec.ConfigValue<List<Integer>> VEIN_BLOCKS_AMOUNT;
        public ForgeConfigSpec.ConfigValue<Integer> VEINS_RARITY;
        public ForgeConfigSpec.ConfigValue<Boolean> RANDOMIZED_ORES;
        public ForgeConfigSpec.ConfigValue<Boolean> ADD_IE_VEINS;
        public ForgeConfigSpec.ConfigValue<Boolean> ALLOW_TO_LEACH_IE_VEINS;

        public InSituLeachingConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for In situ leaching").push("in_situ_leaching");
            this.ENABLE_VEINS = builder.comment("Enable veins generation.").define("enable_veins", true);
            this.VEIN_BLOCKS_AMOUNT = builder.comment("Min and max values of blocks per vein.").comment("Result amount will be random value in this range.").define("blocks_per_vein", List.of(Integer.valueOf(30000), Integer.valueOf(70000)), o -> o instanceof ArrayList);
            this.VEINS_RARITY = builder.comment("Veins rarity. Bigger value - less veins.").defineInRange("veins_rarity", 100, 1, 5000);
            this.RANDOMIZED_ORES = builder.comment("All veins will have random ores. It will ignore vein settings").define("randomized_ores", false);
            this.ADD_IE_VEINS = builder.comment("Add new veins to generation for Immersive Engineering.").define("add_ie_veins", true);
            this.ALLOW_TO_LEACH_IE_VEINS = builder.comment("Allow to leach veins from Immersive Engineering.").comment("To do so, you need to put IE core sample into leacher.").define("allow_to_leach_ie_veins", true);
            builder.pop();
        }
    }
}

