/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class FissionConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final FuelConfig FUEL_CONFIG = new FuelConfig(BUILDER);
    public static final FissionReactorConfig FISSION_CONFIG = new FissionReactorConfig(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    private static boolean loaded = false;
    private static List<Runnable> loadActions = new ArrayList<Runnable>();

    public static <T> List<T> toList(Collection<T> vals) {
        return new ArrayList<T>(vals);
    }

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class FuelConfig {
        public ForgeConfigSpec.ConfigValue<Double> HEAT_MULTIPLIER;
        public ForgeConfigSpec.ConfigValue<Double> FUEL_HEAT_MULTIPLIER;
        public ForgeConfigSpec.ConfigValue<Double> DEPLETION_MULTIPLIER;

        public FuelConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for reactor fuel").push("reactor_fuel");
            this.FUEL_HEAT_MULTIPLIER = builder.comment("Heat multiplier. Affects to all fuels.").defineInRange("fuel_heat_multiplier", 1.0, 0.01, 100.0);
            this.HEAT_MULTIPLIER = builder.comment("Heat multiplier affects on heat/cooling ratio multiplier.").define("heat_multiplier", (Object)3.24444444);
            this.DEPLETION_MULTIPLIER = builder.comment("Depletion multiplier. Affects how long fuel lasts.").defineInRange("depletion_multiplier", 1.0, 0.0, 1000.0);
            builder.pop();
        }
    }

    public static class FissionReactorConfig {
        public ForgeConfigSpec.ConfigValue<Integer> MIN_SIZE;
        public ForgeConfigSpec.ConfigValue<Integer> MAX_SIZE;
        public ForgeConfigSpec.ConfigValue<Double> HEAT_MULTIPLIER;
        public ForgeConfigSpec.ConfigValue<Double> HEAT_MULTIPLIER_CAP;
        public ForgeConfigSpec.ConfigValue<Double> MODERATOR_FE_MULTIPLIER;
        public ForgeConfigSpec.ConfigValue<Double> MODERATOR_HEAT_MULTIPLIER;
        public ForgeConfigSpec.ConfigValue<Double> EXPLOSION_RADIUS;
        public ForgeConfigSpec.ConfigValue<Double> HEAT_CAPACITY;
        public ForgeConfigSpec.ConfigValue<Double> FE_GENERATION_MULTIPLIER;
        public ForgeConfigSpec.ConfigValue<Double> BOILING_MULTIPLIER;
        public ForgeConfigSpec.ConfigValue<Boolean> ACTIVE_HEATSINK_PRIME;
        public ForgeConfigSpec.ConfigValue<Integer> ACTIVE_HEATSINK_COOLANT_PER_TICK;

        public FissionReactorConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for Fission Reactor").push("fission_reactor");
            this.MIN_SIZE = builder.comment("Reactor min size.").defineInRange("min_size", 3, 3, 24);
            this.MAX_SIZE = builder.comment("Reactor max size.").defineInRange("max_size", 24, 5, 24);
            this.EXPLOSION_RADIUS = builder.comment("Explosion size if reactor overheats. 4 - TNT size. Set to 0 to disable explosion.").defineInRange("reactor_explosion_radius", 4.0, 0.0, 20.0);
            this.HEAT_CAPACITY = builder.comment("How much reactor may collect heat before meltdown.").defineInRange("heat_capacity", 1000000.0, 1000.0, 1.0E8);
            this.HEAT_MULTIPLIER = builder.comment("Affects how relation of reactor cooling and heating affects to FE generation.").defineInRange("heat_multiplier", 1.0, 0.01, 20.0);
            this.HEAT_MULTIPLIER_CAP = builder.comment("Limit for heat_multiplier max value.").defineInRange("heat_multiplier_cap", 3.0, 0.01, 3.0);
            this.MODERATOR_FE_MULTIPLIER = builder.comment("Each attachment of moderator to fuel cell will increase fuel FE generation by given percent value.").defineInRange("moderator_fe_multiplier", 16.67, 0.0, 1000.0);
            this.MODERATOR_HEAT_MULTIPLIER = builder.comment("Each attachment of moderator to fuel cell will increase fuel heat generation by given percent value.").defineInRange("moderator_heat_multiplier", 33.34, 0.0, 1000.0);
            this.BOILING_MULTIPLIER = builder.comment("Rate at which steam recipes produced.").defineInRange("boiling_mult", 100.0, 0.01, 1000000.0);
            this.FE_GENERATION_MULTIPLIER = builder.comment("Affects how much energy reactors produce.").defineInRange("fe_generation_multiplier", 10.0, 0.01, 1000000.0);
            this.ACTIVE_HEATSINK_PRIME = builder.comment("If true, active coolers will be counted in placement rules for other heat sinks.").define("active_heatsink_prime", true);
            this.ACTIVE_HEATSINK_COOLANT_PER_TICK = builder.comment("How much coolant active heat sink will consume per tick.").defineInRange("active_heatsink_coolant_per_tick", 100, 1, 10000);
            builder.pop();
        }
    }
}

