/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.recipes.recipes;

import igentuman.nc.content.fuel.FuelManager;
import igentuman.nc.content.materials.Materials;
import igentuman.nc.content.materials.NCMaterial;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.datagen.recipes.builder.NcRecipeBuilder;
import igentuman.nc.datagen.recipes.recipes.AbstractRecipeProvider;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.NcIngredient;
import igentuman.nc.setup.registration.FissionFuel;
import igentuman.nc.setup.registration.NCItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class MelterRecipes
extends AbstractRecipeProvider {
    public static void generate(Consumer<FinishedRecipe> consumer) {
        MelterRecipes.consumer = consumer;
        ID = Processors.MELTER;
        for (String name : Materials.all().keySet()) {
            NCMaterial material = Materials.all().get(name);
            if (!material.fluid || material.isGas) continue;
            MelterRecipes.add(MelterRecipes.dustIngredient(name, new int[0]), MelterRecipes.fluidIngredient(name, 144), new double[0]);
            MelterRecipes.add(MelterRecipes.ingotIngredient(name, new int[0]), MelterRecipes.fluidIngredient(name, 144), new double[0]);
            MelterRecipes.add(MelterRecipes.oreIngredient(name, new int[0]), MelterRecipes.fluidIngredient(name, 288), new double[0]);
            MelterRecipes.add(MelterRecipes.chunkIngredient(name, new int[0]), MelterRecipes.fluidIngredient(name, 216), new double[0]);
        }
        MelterRecipes.add(MelterRecipes.dustIngredient("polonium", new int[0]), MelterRecipes.fluidIngredient("polonium", 144), new double[0]);
        MelterRecipes.add(MelterRecipes.dustIngredient("sulfur", new int[0]), MelterRecipes.fluidIngredient("sulfur", 144), new double[0]);
        MelterRecipes.add(MelterRecipes.ingredient(Items.f_42451_, new int[0]), MelterRecipes.fluidIngredient("redstone", 144), new double[0]);
        MelterRecipes.add(MelterRecipes.ingredient(Items.f_42525_, new int[0]), MelterRecipes.fluidIngredient("glowstone", 144), new double[0]);
        for (String name : Materials.isotopes()) {
            for (String type : new String[]{"", "_ox", "_ni", "_za"}) {
                String key = name + type;
                MelterRecipes.add(MelterRecipes.ingredient((Item)FissionFuel.NC_ISOTOPES.get(key).get(), new int[0]), MelterRecipes.fluidIngredient(key, 144), new double[0]);
            }
        }
        for (String name : FuelManager.all().keySet()) {
            for (String subType : FuelManager.all().get(name).keySet()) {
                for (String type : new String[]{"", "za", "ox", "ni"}) {
                    List<String> key = List.of("fuel", name, subType, type);
                    String keyStr = "fuel_" + name + "_" + subType;
                    if (!type.isEmpty()) {
                        keyStr = keyStr + "_";
                    }
                    keyStr = keyStr + type;
                    MelterRecipes.add(MelterRecipes.ingredient((Item)FissionFuel.NC_FUEL.get(key).get(), new int[0]), MelterRecipes.fluidStackIngredient(keyStr, 144), new double[0]);
                    key = List.of("depleted", name, subType, type);
                    keyStr = "depleted_" + keyStr;
                    MelterRecipes.add(MelterRecipes.ingredient((Item)FissionFuel.NC_DEPLETED_FUEL.get(key).get(), new int[0]), MelterRecipes.fluidStackIngredient(keyStr, 144), new double[0]);
                }
            }
        }
        MelterRecipes.add(MelterRecipes.dustIngredient("sulfur", new int[0]), MelterRecipes.fluidIngredient("sulfur", 144), 0.5, 3.0);
        MelterRecipes.add(MelterRecipes.dustIngredient("sodium_hydroxide", new int[0]), MelterRecipes.fluidIngredient("sodium_hydroxide", 144), new double[0]);
        MelterRecipes.add(MelterRecipes.dustIngredient("potassium_hydroxide", new int[0]), MelterRecipes.fluidIngredient("potassium_hydroxide", 144), new double[0]);
        MelterRecipes.add(MelterRecipes.dustIngredient("arsenic", new int[0]), MelterRecipes.fluidIngredient("arsenic", 144), new double[0]);
        MelterRecipes.add(MelterRecipes.gemIngredient("boron_arsenide", new int[0]), MelterRecipes.fluidIngredient("boron_arsenide", 144), new double[0]);
        MelterRecipes.add(MelterRecipes.ingredient(Items.f_41999_, new int[0]), MelterRecipes.fluidIngredient("obsidian", 288), 2.0, 2.0);
        MelterRecipes.add(MelterRecipes.ingredient((Item)NCItems.NC_ITEMS.get("ground_cocoa_nibs").get(), new int[0]), MelterRecipes.fluidIngredient("chocolate_liquor", 144), 0.25, 0.5);
        MelterRecipes.add(MelterRecipes.ingredient((Item)NCItems.NC_ITEMS.get("cocoa_butter").get(), new int[0]), MelterRecipes.fluidIngredient("cocoa_butter", 144), 0.25, 0.5);
        MelterRecipes.add(MelterRecipes.ingredient((Item)NCItems.NC_ITEMS.get("unsweetened_chocolate").get(), new int[0]), MelterRecipes.fluidIngredient("unsweetened_chocolate", 144), 0.25, 0.5);
        MelterRecipes.add(MelterRecipes.ingredient((Item)NCItems.NC_FOOD.get("dark_chocolate").get(), new int[0]), MelterRecipes.fluidIngredient("dark_chocolate", 144), 0.25, 0.5);
        MelterRecipes.add(MelterRecipes.ingredient((Item)NCItems.NC_FOOD.get("milk_chocolate").get(), new int[0]), MelterRecipes.fluidIngredient("milk_chocolate", 144), 0.25, 0.5);
        MelterRecipes.add(MelterRecipes.ingredient(Items.f_42501_, new int[0]), MelterRecipes.fluidIngredient("sugar", 144), 0.5, 0.5);
        MelterRecipes.add(MelterRecipes.ingredient((Item)NCItems.NC_ITEMS.get("gelatin").get(), new int[0]), MelterRecipes.fluidIngredient("gelatin", 144), 0.5, 0.5);
        MelterRecipes.add(MelterRecipes.ingredient((Item)NCItems.NC_FOOD.get("marshmallow").get(), new int[0]), MelterRecipes.fluidIngredient("marshmallow", 144), 0.5, 0.5);
    }

    protected static void add(NcIngredient inputItem, FluidStackIngredient outputFluid, double ... modifiers) {
        try {
            MelterRecipes.itemToFluid(List.of(inputItem), new ArrayList<NcIngredient>(), new ArrayList<FluidStackIngredient>(), List.of(outputFluid), modifiers);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void itemToFluid(List<NcIngredient> inputItems, List<NcIngredient> outputItems, List<FluidStackIngredient> inputFluids, List<FluidStackIngredient> outputFluids, double ... params) {
        double timeModifier = params.length > 0 ? params[0] : 1.0;
        double powerModifier = params.length > 1 ? params[1] : 1.0;
        double radiation = params.length > 2 ? params[2] : 1.0;
        NcRecipeBuilder.get(ID).items(inputItems, outputItems).fluids(inputFluids, outputFluids).modifiers(timeModifier, radiation, powerModifier).build(consumer);
    }
}

