/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.recipes.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.nc.datagen.recipes.builder.RecipeCriterion;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeBuilder<BUILDER extends RecipeBuilder<BUILDER>> {
    protected final List<ICondition> conditions = new ArrayList<ICondition>();
    protected final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    protected final ResourceLocation serializerName;

    protected static ResourceLocation ncSerializer(String name) {
        return new ResourceLocation("nuclearcraft", name);
    }

    protected RecipeBuilder(ResourceLocation serializerName) {
        this.serializerName = serializerName;
    }

    public BUILDER addCriterion(RecipeCriterion criterion) {
        return this.addCriterion(criterion.name(), criterion.criterion());
    }

    public BUILDER addCriterion(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        return (BUILDER)this;
    }

    public BUILDER addCondition(ICondition condition) {
        this.conditions.add(condition);
        return (BUILDER)this;
    }

    protected boolean hasCriteria() {
        return !this.advancementBuilder.m_138405_().isEmpty();
    }

    protected abstract RecipeResult getResult(ResourceLocation var1);

    protected void validate(ResourceLocation id) {
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        if (this.hasCriteria()) {
            this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        }
        consumer.accept(this.getResult(id));
    }

    protected void build(Consumer<FinishedRecipe> consumer, ItemLike ... output) {
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)output[0].m_5456_());
        if (registryName == null) {
            throw new IllegalStateException("Could not retrieve registry name for output.");
        }
        this.build(consumer, registryName);
    }

    public static JsonElement serializeItemStack(@NotNull ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        if (stack.m_41613_() > 1) {
            json.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41782_()) {
            if (stack.m_41783_().m_128441_("Damage") && stack.m_41783_().m_128451_("Damage") == 0) {
                stack.m_41783_().m_128473_("Damage");
            }
            if (!stack.m_41783_().m_128431_().isEmpty()) {
                json.addProperty("nbt", stack.m_41783_().toString());
            }
        }
        return json;
    }

    public static JsonElement serializeIngredient(@NotNull Ingredient ingredient) {
        return ingredient.m_43942_();
    }

    public static JsonElement serializeFluidStack(@NotNull FluidStack fluidStack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)fluidStack.getFluid()).toString());
        json.addProperty("amount", (Number)fluidStack.getAmount());
        if (fluidStack.hasTag()) {
            if (fluidStack.getTag().m_128441_("Damage") && fluidStack.getTag().m_128451_("Damage") == 0) {
                fluidStack.getTag().m_128473_("Damage");
            }
            if (!fluidStack.getTag().m_128431_().isEmpty()) {
                json.addProperty("nbt", fluidStack.getTag().toString());
            }
        }
        return json;
    }

    protected abstract class RecipeResult
    implements FinishedRecipe {
        private final ResourceLocation id;

        public RecipeResult(ResourceLocation id) {
            this.id = id;
        }

        public JsonObject m_125966_() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", RecipeBuilder.this.serializerName.toString());
            if (!RecipeBuilder.this.conditions.isEmpty()) {
                JsonArray conditionsArray = new JsonArray();
                for (ICondition condition : RecipeBuilder.this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                jsonObject.add("conditions", (JsonElement)conditionsArray);
            }
            this.m_7917_(jsonObject);
            return jsonObject;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(RecipeBuilder.this.serializerName);
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return RecipeBuilder.this.hasCriteria() ? RecipeBuilder.this.advancementBuilder.m_138400_() : null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return new ResourceLocation(this.id.m_135827_(), "recipes/" + this.id.m_135815_());
        }
    }
}

