/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.materials;

public class NCMaterial {
    public String name;
    public boolean normal_ore = true;
    public boolean nether_ore = false;
    public boolean end_ore = false;
    public boolean gem = false;
    public boolean deepslate_ore = true;
    public boolean chunk = true;
    public boolean ingot = true;
    public boolean nugget = true;
    public boolean block = true;
    public boolean fluid = true;
    public int temperature = 1000;
    public int density = 200;
    public boolean isGas = false;
    public boolean plate = true;
    public boolean dust = true;
    public int color = -1;

    private NCMaterial(String name) {
        this.name = name;
    }

    public static NCMaterial get(String name) {
        return new NCMaterial(name);
    }

    public static NCMaterial ore(String name) {
        return NCMaterial.get(name);
    }

    public static NCMaterial metal(String name) {
        return NCMaterial.get(name).ores(false, false, false, false).products(false, true, true, true, true, true).fluid(true, 1000);
    }

    public static NCMaterial alloy(String name) {
        return NCMaterial.get(name).ores(false, false, false, false).products(false, true, true, true, true, true).fluid(true, 1000);
    }

    public static NCMaterial gem(String name) {
        return NCMaterial.get(name).ores(false, false, false, false).products(false, false, false, false, false, false).with("gem").fluid(false, 1000);
    }

    public static NCMaterial dust(String name) {
        return NCMaterial.get(name).ores(false, false, false, false).products(false, true, false, false, false, false).fluid(false, 1000);
    }

    public NCMaterial ores(boolean normal_ore, boolean deepslate_ore, boolean nether_ore, boolean end_ore) {
        this.normal_ore = normal_ore;
        this.deepslate_ore = deepslate_ore;
        this.nether_ore = nether_ore;
        this.end_ore = end_ore;
        return this;
    }

    public NCMaterial products(boolean chunk, boolean dust, boolean ingot, boolean nugget, boolean block, boolean plate) {
        this.chunk = chunk;
        this.dust = dust;
        this.ingot = ingot;
        this.nugget = nugget;
        this.block = block;
        this.plate = plate;
        return this;
    }

    public NCMaterial with(String ... args) {
        for (String str : args) {
            try {
                this.getClass().getDeclaredField(str).set(this, true);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return this;
    }

    public NCMaterial define(String ... args) {
        this.normal_ore = false;
        this.deepslate_ore = false;
        this.chunk = false;
        this.ingot = false;
        this.nugget = false;
        this.block = false;
        this.fluid = false;
        this.plate = false;
        this.dust = false;
        for (String str : args) {
            try {
                this.getClass().getDeclaredField(str).set(this, true);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return this;
    }

    public NCMaterial color(int color) {
        this.color = color;
        return this;
    }

    public NCMaterial fluid(boolean fluid, int temperature) {
        this.fluid = fluid;
        this.temperature = temperature;
        return this;
    }

    public boolean hasOre() {
        return this.deepslate_ore || this.normal_ore || this.nether_ore || this.end_ore;
    }
}

