/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content;

import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.FusionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class Electromagnets {
    private static HashMap<String, MagnetPrefab> all = new HashMap();
    private static HashMap<String, MagnetPrefab> registered = new HashMap();

    public static HashMap<String, MagnetPrefab> all() {
        if (all.isEmpty()) {
            all.put("basic_electromagnet", new MagnetPrefab("basic_electromagnet", 500, 300, 0.25, 350000, 75));
            all.put("magnesium_diboride_electromagnet", new MagnetPrefab("magnesium_diboride_electromagnet", 1000, 500, 0.5, 39000, 80));
            all.put("niobium_tin_electromagnet", new MagnetPrefab("niobium_tin_electromagnet", 1500, 1140, 1.0, 18000, 90));
            all.put("niobium_titanium_electromagnet", new MagnetPrefab("niobium_titanium_electromagnet", 2000, 2260, 2.0, 10000, 95));
            all.put("bscco_electromagnet", new MagnetPrefab("bscco_electromagnet", 3000, 4500, 4.0, 104000, 99));
        }
        return all;
    }

    public static HashMap<String, MagnetPrefab> registered() {
        if (registered.isEmpty()) {
            for (String name : Electromagnets.all().keySet()) {
                if (!Electromagnets.all().get(name).config().isRegistered()) continue;
                registered.put(name, Electromagnets.all().get(name));
            }
        }
        return registered;
    }

    public static List<Boolean> initialRegistered() {
        ArrayList<Boolean> tmp = new ArrayList<Boolean>();
        for (String name : Electromagnets.all().keySet()) {
            tmp.add(true);
        }
        return tmp;
    }

    public static List<Integer> initialPower() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (String name : Electromagnets.all().keySet()) {
            tmp.add(Electromagnets.all().get(name).getPower());
        }
        return tmp;
    }

    public static Collection<Double> initialMagneticField() {
        ArrayList<Double> tmp = new ArrayList<Double>();
        for (String name : Electromagnets.all().keySet()) {
            tmp.add(Electromagnets.all().get(name).getMagneticField());
        }
        return tmp;
    }

    public static Collection<Integer> initialHeat() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (String name : Electromagnets.all().keySet()) {
            tmp.add(Electromagnets.all().get(name).getHeat());
        }
        return tmp;
    }

    public static class MagnetPrefab {
        private boolean registered = true;
        private boolean initialized = false;
        private String name;
        protected int power = 0;
        protected double magneticField = 0.0;
        protected int heat = 0;
        protected int maxTemp = 0;
        protected int efficiency = 0;

        public MagnetPrefab(String name, int energy, int heat, double magneticField, int maxTemp, int efficiency) {
            this.power = energy;
            this.name = name;
            this.heat = heat;
            this.magneticField = magneticField;
            this.maxTemp = maxTemp;
            this.efficiency = efficiency;
        }

        public int getPower() {
            return this.power;
        }

        public MagnetPrefab setPower(int power) {
            this.power = power;
            return this;
        }

        public MagnetPrefab config() {
            if (!this.initialized) {
                if (!CommonConfig.isLoaded()) {
                    return this;
                }
                int id = Electromagnets.all().keySet().stream().toList().indexOf(this.name);
                this.registered = (Boolean)((List)FusionConfig.ELECTROMAGNETS_CONFIG.REGISTERED.get()).get(id);
                this.power = (Integer)((List)FusionConfig.ELECTROMAGNETS_CONFIG.POWER.get()).get(id);
                this.heat = (Integer)((List)FusionConfig.ELECTROMAGNETS_CONFIG.HEAT.get()).get(id);
                this.magneticField = (Double)((List)FusionConfig.ELECTROMAGNETS_CONFIG.MAGNETIC_FIELD.get()).get(id);
                this.initialized = true;
            }
            return this;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public double getMagneticField() {
            return this.magneticField;
        }

        public int getHeat() {
            return this.heat;
        }

        public int getEfficiency() {
            return this.efficiency;
        }

        public int getMaxTemp() {
            return this.maxTemp;
        }
    }
}

