/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.container;

import igentuman.nc.block.entity.turbine.TurbineControllerBE;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.util.TextUtils;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class TurbineControllerContainer
extends AbstractContainerMenu {
    protected TurbineControllerBE<?> blockEntity;
    protected Player playerEntity;
    protected String name = "turbine_controller";
    private int slotIndex = 0;
    protected IItemHandler playerInventory;

    public TurbineControllerContainer(int pContainerId, BlockPos pos, Inventory playerInventory) {
        super((MenuType)TurbineRegistration.TURBINE_CONTROLLER_CONTAINER.get(), pContainerId);
        this.playerEntity = playerInventory.f_35978_;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.blockEntity = (TurbineControllerBE)this.playerEntity.m_20193_().m_7702_(pos);
        this.layoutPlayerInventorySlots();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return TurbineControllerContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)Objects.requireNonNull(this.blockEntity.m_58904_()), (BlockPos)this.blockEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)TurbineRegistration.TURBINE_BLOCKS.get(this.name).get()));
    }

    public Component getTitle() {
        return Component.m_237115_((String)("block.nuclearcraft." + this.name));
    }

    public boolean isCasingValid() {
        return this.blockEntity.isCasingValid;
    }

    public int[] getDimensions() {
        return new int[]{this.getHeight(), this.getWidth(), this.getDepth()};
    }

    public int getDepth() {
        return this.blockEntity.getDepth();
    }

    public int getWidth() {
        return this.blockEntity.getWidth();
    }

    public int getHeight() {
        return this.blockEntity.getHeight();
    }

    public boolean isInteriorValid() {
        return this.blockEntity.isInternalValid;
    }

    public BlockPos getValidationResultData() {
        return this.blockEntity.errorBlockPos;
    }

    public String getValidationResultKey() {
        return this.blockEntity.validationResult.messageKey;
    }

    public int getEnergy() {
        return this.blockEntity.energyStorage.getEnergyStored();
    }

    private void addSlotRange(IItemHandler handler, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, this.slotIndex, x, y));
            x += dx;
            ++this.slotIndex;
        }
    }

    protected void addSlotBox(IItemHandler handler, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            this.addSlotRange(handler, x, y, horAmount, dx);
            y += dy;
        }
    }

    protected void layoutPlayerInventorySlots() {
        int leftCol = 8;
        int topRow = 153;
        this.addSlotRange(this.playerInventory, leftCol, topRow, 9, 18);
        this.addSlotBox(this.playerInventory, leftCol, topRow -= 58, 9, 18, 3, 18);
    }

    public int getMaxEnergy() {
        return this.blockEntity.energyStorage.getMaxEnergyStored();
    }

    public String getEfficiency() {
        return TextUtils.roundFormat(this.blockEntity.coilsEfficiency);
    }

    public int energyPerTick() {
        return this.blockEntity.energyPerTick;
    }

    public boolean hasRecipe() {
        return this.blockEntity.hasRecipe();
    }

    public int getActiveCoils() {
        return this.blockEntity.getActiveCoils();
    }

    public int getFlow() {
        return this.blockEntity.getFlow();
    }

    public FluidTank getFluidTank(int i) {
        return this.blockEntity.getFluidTank(i);
    }

    public int getRealFlow() {
        return this.blockEntity.realFlow;
    }
}

