/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.oc2;

import igentuman.nc.block.entity.turbine.TurbineControllerBE;
import java.util.Collection;
import java.util.Collections;
import li.cil.oc2r.api.bus.device.Device;
import li.cil.oc2r.api.bus.device.object.Callback;
import li.cil.oc2r.api.bus.device.object.NamedDevice;
import li.cil.oc2r.api.bus.device.object.ObjectDevice;
import li.cil.oc2r.api.bus.device.rpc.RPCDevice;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.jetbrains.annotations.NotNull;

public class NCTurbineDevice {
    public static final Capability<Device> DEVICE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Device>(){});

    public static RPCDevice createDevice(TurbineControllerBE<?> blockEntity) {
        return new ObjectDevice((Object)new NCFTurbineDeviceRecord(blockEntity));
    }

    public record NCFTurbineDeviceRecord(TurbineControllerBE<?> turbine) implements NamedDevice
    {
        @Callback
        public final String getName() {
            return this.turbine.getName();
        }

        @Callback
        public final boolean hasRecipe() {
            return this.turbine.hasRecipe();
        }

        @Callback
        public final void enableTurbine() {
            this.turbine.disableForceShutdown();
        }

        @Callback
        public final void disableTurbine() {
            this.turbine.forceShutdown();
        }

        @Callback
        public final int getEnergyPerTick() {
            return this.turbine.energyPerTick;
        }

        @Callback
        public final int getEnergyStored() {
            return this.turbine.energyStorage.getEnergyStored();
        }

        @NotNull
        public Collection<String> getDeviceTypeNames() {
            return Collections.singletonList(this.getName());
        }
    }
}

