/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.fission.FissionControllerBE;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.compat.jei.util.TickTimer;
import igentuman.nc.recipes.AbstractRecipe;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class FissionCategoryWrapper<T extends FissionControllerBE.Recipe>
implements IRecipeCategory<T> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("nuclearcraft", "textures/gui/fission/jei.png");
    private final IDrawable background;
    private final IDrawable icon;
    protected RecipeType<T> recipeType;
    HashMap<Integer, TickTimer> timer = new HashMap();
    HashMap<Integer, IDrawable> arrow = new HashMap();
    IGuiHelper guiHelper;

    public FissionCategoryWrapper(IGuiHelper guiHelper, RecipeType<T> recipeType) {
        this.recipeType = recipeType;
        this.guiHelper = guiHelper;
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 98, 30);
        this.icon = GlobalVars.CATALYSTS.containsKey(this.getRecipeType().getUid().m_135815_()) ? guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)GlobalVars.CATALYSTS.get(this.getRecipeType().getUid().m_135815_()).get(0)) : guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_41852_));
    }

    @NotNull
    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (mouseX > 29.0 && mouseX < 65.0 && mouseY > 8.0 && mouseY < 24.0) {
            lines.add((Component)Component.m_237110_((String)"fission.recipe.duration", (Object[])new Object[]{(int)((double)((FissionControllerBE.Recipe)recipe).getDepletionTime() / 20.0)}).m_130940_(ChatFormatting.AQUA));
            lines.add((Component)Component.m_237110_((String)"fission.recipe.power", (Object[])new Object[]{(int)((FissionControllerBE.Recipe)recipe).getEnergy()}).m_130940_(ChatFormatting.RED));
            lines.add((Component)Component.m_237110_((String)"fission.recipe.radiation", (Object[])new Object[]{TextUtils.numberFormat(((FissionControllerBE.Recipe)recipe).getRadiation() * 1000000.0)}).m_130940_(ChatFormatting.GREEN));
            lines.add((Component)Component.m_237110_((String)"fission.recipe.heat", (Object[])new Object[]{(int)((FissionControllerBE.Recipe)recipe).getHeat()}).m_130940_(ChatFormatting.GOLD));
        }
        return lines;
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)("nc_jei_cat." + this.getRecipeType().getUid().m_135815_()));
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        if (this.arrow.containsKey(((FissionControllerBE.Recipe)recipe).getDepletionTime())) {
            this.arrow.get(((FissionControllerBE.Recipe)recipe).getDepletionTime()).draw(graphics, 29, 8);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        int d = ((FissionControllerBE.Recipe)recipe).getDepletionTime();
        if (!this.timer.containsKey(d)) {
            this.timer.put(d, new TickTimer((int)(((AbstractRecipe)recipe).getTimeModifier() * (double)d) / 50, 36, true));
        }
        if (!this.arrow.containsKey(d)) {
            this.arrow.put(d, (IDrawable)this.guiHelper.drawableBuilder(NuclearCraft.rl("textures/gui/progress.png"), 0, 186, 36, 15).buildAnimated((ITickTimer)this.timer.get(d), IDrawableAnimated.StartDirection.LEFT));
        }
        for (int i = 0; i < ((AbstractRecipe)recipe).getItemIngredients().size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 11 + 18 * i, 7).addIngredients((Ingredient)((AbstractRecipe)recipe).getItemIngredients().get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 74, 7).addItemStack(((AbstractRecipe)recipe).getResultItem());
    }
}

