/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.energy;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.ISizeToggable;
import igentuman.nc.block.entity.energy.NCEnergy;
import igentuman.nc.content.energy.BatteryBlocks;
import igentuman.nc.handler.config.CommonConfig;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class BatteryBE
extends NCEnergy {
    public static final ModelProperty<HashMap<Integer, ISizeToggable.SideMode>> SIDE_CONFIG = new ModelProperty();
    public boolean syncSideConfig = true;
    private int chargeCooldown = 0;

    public BatteryBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, BatteryBE.getName(pBlockState));
        for (Direction direction : Direction.values()) {
            this.sideConfig.put(direction.ordinal(), ISizeToggable.SideMode.DEFAULT);
        }
    }

    public static String getName(BlockState pBlockState) {
        return pBlockState.m_60734_().m_5456_().toString();
    }

    @Nonnull
    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(SIDE_CONFIG, (Object)this.sideConfig).build();
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped) {
            return;
        }
        super.tickServer();
        this.transferEnergy();
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
    }

    protected void transferEnergy() {
        AtomicInteger capacity = new AtomicInteger(this.energyStorage.getEnergyStored());
        for (Direction direction : Direction.values()) {
            IEnergyStorage sideEnergy;
            BlockEntity be;
            if (this.sideConfig.get(direction.ordinal()) == ISizeToggable.SideMode.DISABLED || this.sideConfig.get(direction.ordinal()) == ISizeToggable.SideMode.DEFAULT || (be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction))) == null || (sideEnergy = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).orElse(null)) == null) continue;
            if (capacity.get() > 0 && this.sideConfig.get(direction.ordinal()) == ISizeToggable.SideMode.OUT) {
                int accepted = sideEnergy.receiveEnergy(Math.min(capacity.get(), this.getEnergyTransferPerTick()), false);
                capacity.addAndGet(-accepted);
                continue;
            }
            if (capacity.get() >= this.getEnergyMaxStorage() || this.sideConfig.get(direction.ordinal()) != ISizeToggable.SideMode.IN) continue;
            int extracted = sideEnergy.extractEnergy(Math.min(this.getEnergyTransferPerTick(), this.getEnergyMaxStorage() - capacity.get()), false);
            capacity.addAndGet(extracted);
        }
        if (capacity.get() != this.energyStorage.getEnergyStored()) {
            this.energyStorage.setEnergy(capacity.get());
            this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side != null && this.sideConfig.get(side.ordinal()) != ISizeToggable.SideMode.DISABLED) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        int oldEnergy = this.energyStorage.getEnergyStored();
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
        if (oldEnergy != this.energyStorage.getEnergyStored()) {
            this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    protected int getEnergyTransferPerTick() {
        return Math.min(BatteryBlocks.all().get(this.getName()).getStorage(), this.energyStorage.getEnergyStored());
    }

    @Override
    public int getMaxTransfer() {
        return this.getEnergyMaxStorage();
    }

    @Override
    protected int getEnergyMaxStorage() {
        return BatteryBlocks.all().get(this.m_58900_().m_60734_().m_5456_().toString()).getStorage();
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        super.saveClientData(tag);
        tag.m_128385_("sideConfig", this.sideConfig.values().stream().mapToInt(Enum::ordinal).toArray());
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        super.loadClientData(tag);
        if (!tag.m_128441_("sideConfig")) {
            return;
        }
        this.loadSideConfig(tag.m_128465_("sideConfig"));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (!tag.m_128441_("sideConfig")) {
            return;
        }
        this.loadSideConfig(tag.m_128465_("sideConfig"));
    }

    private void loadSideConfig(int[] tagData) {
        boolean changed = false;
        for (int i = 0; i < this.sideConfig.size(); ++i) {
            ISizeToggable.SideMode newMode = ISizeToggable.SideMode.values()[tagData[i]];
            if (this.sideConfig.get(i) == newMode) continue;
            changed = true;
            this.sideConfig.remove(i);
            this.sideConfig.put(i, newMode);
        }
        if (changed) {
            this.requestModelDataUpdate();
            if (this.f_58857_ == null) {
                return;
            }
            this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128385_("sideConfig", this.sideConfig.values().stream().mapToInt(Enum::ordinal).toArray());
    }

    public ISizeToggable.SideMode toggleSideConfig(int direction) {
        this.sideConfig.put(direction, ISizeToggable.SideMode.values()[(((ISizeToggable.SideMode)((Object)this.sideConfig.get(direction))).ordinal() + 1) % 4]);
        this.m_6596_();
        this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        return (ISizeToggable.SideMode)((Object)this.sideConfig.get(direction));
    }

    public void onLightningStrike() {
        if (this.chargeCooldown > 0) {
            return;
        }
        this.chargeCooldown = 600;
        this.energyStorage.addEnergy((Integer)CommonConfig.ENERGY_STORAGE.LIGHTNING_ROD_CHARGE.get());
        this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        BlockPos pos = this.f_58858_;
        Direction direction = Direction.UP;
        Direction.Axis direction$axis = direction.m_122434_();
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = pos.m_123342_();
        double d2 = (double)pos.m_123343_() + 0.5;
        double d3 = 0.52;
        double d4 = this.f_58857_.m_213780_().m_188500_() * 0.6 - 0.3;
        double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
        double d6 = this.f_58857_.m_213780_().m_188500_() * 6.0 / 16.0;
        double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
        this.f_58857_.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
    }
}

