/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundRemoveUpgradePacket {
    private final int slot;

    public ServerboundRemoveUpgradePacket(int slot) {
        this.slot = slot;
    }

    public static ServerboundRemoveUpgradePacket decode(FriendlyByteBuf buffer) {
        int slot = buffer.readInt();
        return new ServerboundRemoveUpgradePacket(slot);
    }

    public static void encode(ServerboundRemoveUpgradePacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slot);
    }

    public static void handle(ServerboundRemoveUpgradePacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player instanceof ServerPlayer) {
                BackpackBaseMenu menu;
                BackpackWrapper wrapper;
                ServerPlayer serverPlayer = player;
                AbstractContainerMenu patt1503$temp = serverPlayer.f_36096_;
                if (patt1503$temp instanceof BackpackBaseMenu && !(wrapper = (menu = (BackpackBaseMenu)patt1503$temp).getWrapper()).getUpgrades().getStackInSlot(message.slot).m_41619_()) {
                    Optional<? extends IUpgrade> upgrade = wrapper.getUpgradeManager().mappedUpgrades.get(message.slot);
                    ItemStack upgradeStack = wrapper.getUpgrades().getStackInSlot(message.slot).m_41777_();
                    NbtHelper.set(upgradeStack, "TabOpen", false);
                    wrapper.getUpgrades().setStackInSlot(message.slot, ItemStack.f_41583_);
                    upgrade.ifPresent(iUpgrade -> iUpgrade.onUpgradeRemoved(upgradeStack));
                    if (!serverPlayer.m_150109_().m_36054_(upgradeStack)) {
                        serverPlayer.m_36176_(upgradeStack, true);
                    }
                    for (Player user : wrapper.getPlayersUsing()) {
                        if (!(user.f_36096_ instanceof BackpackBaseMenu)) continue;
                        user.f_36096_.m_182423_();
                    }
                    wrapper.saveHandler.run();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

