/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundOpenBackpackPacket {
    private final int slotIndex;

    public ServerboundOpenBackpackPacket(int slotIndex) {
        this.slotIndex = slotIndex;
    }

    public static ServerboundOpenBackpackPacket decode(FriendlyByteBuf buffer) {
        int slotIndex = buffer.readInt();
        return new ServerboundOpenBackpackPacket(slotIndex);
    }

    public static void encode(ServerboundOpenBackpackPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotIndex);
    }

    public static void handle(ServerboundOpenBackpackPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Slot slot = player.f_36096_.m_38853_(message.slotIndex);
            if (slot != null && slot.m_7993_().m_41720_() instanceof TravelersBackpackItem && slot.m_150651_((Player)player) && slot.f_40218_ instanceof Inventory && !((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.allowOnlyEquippedBackpack.get()).booleanValue()) {
                BackpackContainer.openBackpack(player, slot.m_7993_(), (byte)1);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

