/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundAbilitySliderPacket {
    private final byte screenID;
    private final boolean sliderValue;

    public ServerboundAbilitySliderPacket(byte screenID, boolean sliderValue) {
        this.screenID = screenID;
        this.sliderValue = sliderValue;
    }

    public static ServerboundAbilitySliderPacket decode(FriendlyByteBuf buffer) {
        byte screenID = buffer.readByte();
        boolean sliderValue = buffer.readBoolean();
        return new ServerboundAbilitySliderPacket(screenID, sliderValue);
    }

    public static void encode(ServerboundAbilitySliderPacket message, FriendlyByteBuf buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeBoolean(message.sliderValue);
    }

    public static void handle(ServerboundAbilitySliderPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapper((Player)player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                AbstractContainerMenu patt1886$temp = serverPlayer.f_36096_;
                if (patt1886$temp instanceof BackpackBaseMenu) {
                    BackpackBaseMenu menu = (BackpackBaseMenu)patt1886$temp;
                    wrapper = menu.getWrapper();
                }
            }
            ServerActions.switchAbilitySlider(wrapper, message.sliderValue);
            wrapper.sendDataToClients("AbilityEnabled");
        });
        ctx.get().setPacketHandled(true);
    }
}

