/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.SlotPositioner;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public class BackpackItemMenu
extends BackpackBaseMenu {
    public BackpackItemMenu(int windowID, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowID, playerInventory, BackpackItemMenu.createWrapper(playerInventory, data));
    }

    public BackpackItemMenu(int windowID, Inventory playerInventory, BackpackWrapper wrapper) {
        super((MenuType)ModMenuTypes.BACKPACK_MENU.get(), windowID, playerInventory, wrapper);
        this.wrapper.addUser(playerInventory.f_35978_);
    }

    private static BackpackWrapper createWrapper(Inventory inventory, FriendlyByteBuf data) {
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        byte screenID = data.readByte();
        int entityId = data.readInt();
        if (screenID == 2) {
            if (entityId != -1) {
                BackpackWrapper targetWrapper = CapabilityUtils.getBackpackWrapper((Player)inventory.f_35978_.m_9236_().m_6815_(entityId));
                targetWrapper.addUser(inventory.f_35978_);
                return targetWrapper;
            }
            return CapabilityUtils.getBackpackWrapper(inventory.f_35978_);
        }
        return new BackpackWrapper(inventory.f_35978_.m_21120_(InteractionHand.MAIN_HAND), screenID, inventory.f_35978_, (LevelAccessor)inventory.f_35978_.m_9236_());
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (this.getWrapper().getScreenID() == 1 && clickType == ClickType.SWAP) {
            ItemStack stack = player.m_150109_().m_8020_(dragType);
            ItemStack currentItem = player.m_150109_().m_36056_();
            if (!currentItem.m_41619_() && stack == currentItem) {
                return;
            }
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    @Override
    public void addPlayerInventoryAndHotbar(Inventory inventory, int currentItemIndex) {
        int modifiedOffset = this.extendedScreenOffset;
        SlotPositioner pos = this.wrapper.getSlotPositioner();
        if (pos.isExtended()) {
            modifiedOffset += 18;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, 11 + pos.getRows() * 18 + 10 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            if (x == currentItemIndex && this.wrapper.getScreenID() == 1) {
                this.m_38897_(new DisabledSlot((Container)inventory, x, modifiedOffset + 8 + x * 18, 69 + pos.getRows() * 18 + 10));
                continue;
            }
            this.m_38897_(new Slot((Container)inventory, x, modifiedOffset + 8 + x * 18, 69 + pos.getRows() * 18 + 10));
        }
    }

    @Override
    public void m_6877_(Player player) {
        if (player.f_36096_ instanceof BackpackBaseMenu && player.m_9236_().f_46443_) {
            return;
        }
        this.wrapper.playersUsing.remove(player);
        super.m_6877_(player);
    }

    @Override
    public boolean m_6875_(Player player) {
        if (this.getWrapper().getBackpackOwner() != null) {
            return this.getWrapper().getBackpackOwner().m_6084_() && CapabilityUtils.isWearingBackpack(this.getWrapper().getBackpackOwner());
        }
        return true;
    }
}

