/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.SlotPositioner;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;

public class BackpackWrapper {
    public static final BackpackWrapper DUMMY = new BackpackWrapper(((TravelersBackpackItem)((Object)ModItems.STANDARD_TRAVELERS_BACKPACK.get())).m_7968_(), 3, null, null);
    protected ItemStack stack;
    public final ItemStackHandler inventory;
    public final ItemStackHandler upgrades;
    public final ItemStackHandler tools;
    public ItemStackHandler upgradesTracker;
    private final UpgradeManager upgradeManager;
    private final SlotPositioner slotPositioner;
    private Player owner;
    public ArrayList<Player> playersUsing = new ArrayList();
    protected LevelAccessor levelAccessor;
    private final byte screenID;
    private int tanksCapacity = 0;
    public Runnable saveHandler = () -> {};
    public Runnable abilityHandler = () -> {};
    public BlockPos backpackPos;
    public static final byte STORAGE_ID = 0;
    public static final byte UGPRADES_ID = 1;
    public static final byte TOOLS_ID = 2;

    public BackpackWrapper(ItemStack stack, byte screenID, @Nullable Player player, @Nullable LevelAccessor levelAccessor) {
        if (player != null) {
            this.playersUsing.add(player);
        }
        if (screenID == 2) {
            this.setBackpackOwner(player);
        }
        this.stack = stack;
        if (!BackpackWrapper.isSizeInitialized(stack)) {
            BackpackWrapper.initializeSize(stack);
        }
        int storageSlots = (Integer)NbtHelper.get(stack, "StorageSlots");
        int upgradeSlots = (Integer)NbtHelper.get(stack, "UpgradeSlots");
        int toolSlots = (Integer)NbtHelper.get(stack, "ToolSlots");
        this.screenID = screenID;
        this.levelAccessor = levelAccessor;
        this.inventory = this.createHandler(storageSlots, (byte)0);
        this.upgrades = this.createUpgradeHandler(upgradeSlots, (byte)1);
        this.tools = this.createHandler(toolSlots, (byte)2);
        this.upgradesTracker = new ItemStackHandler(this.upgrades.getSlots());
        this.loadInventoriesFromComponent(this.stack);
        this.slotPositioner = new SlotPositioner(storageSlots);
        this.setBackpackTankCapacity();
        this.upgradeManager = new UpgradeManager(this);
        if (!NbtHelper.has(stack, "RenderInfo")) {
            this.setRenderInfo(RenderInfo.EMPTY.compoundTag());
        }
        if (NbtHelper.has(stack, "StarterUpgrades")) {
            List upgrades = (List)NbtHelper.get(stack, "StarterUpgrades");
            upgrades.forEach(this::setStarterUpgrade);
            NbtHelper.remove(stack, "StarterUpgrades");
        }
        this.converter(stack, storageSlots, toolSlots);
        this.setAbilityState();
    }

    public void setBackpackStack(ItemStack backpack) {
        this.stack = backpack;
        this.getUpgradeManager().tanksUpgrade.ifPresent(tanksUpgrade -> tanksUpgrade.syncClients(backpack));
    }

    public ItemStack getBackpackStack() {
        return this.stack;
    }

    public void setBackpackOwner(Player player) {
        this.owner = player;
    }

    @Nullable
    public Player getBackpackOwner() {
        return this.owner;
    }

    public ArrayList<Player> getPlayersUsing() {
        return this.playersUsing;
    }

    public void addUser(Player player) {
        if (!this.playersUsing.contains(player)) {
            this.playersUsing.add(player);
        }
    }

    public void loadInventoriesFromComponent(ItemStack backpack) {
        CompoundTag contents;
        if (NbtHelper.has(backpack, "Inventory")) {
            contents = NbtHelper.getHandlerNbt(backpack, "Inventory");
            if (contents.m_128441_("Size")) {
                contents.m_128473_("Size");
            }
            this.inventory.deserializeNBT(contents);
        }
        if (NbtHelper.has(backpack, "Upgrades")) {
            contents = NbtHelper.getHandlerNbt(backpack, "Upgrades");
            if (contents.m_128441_("Size")) {
                contents.m_128473_("Size");
            }
            this.upgrades.deserializeNBT(contents);
            this.upgradesTracker.deserializeNBT(contents);
        }
        if (NbtHelper.has(backpack, "ToolsInventory")) {
            contents = NbtHelper.getHandlerNbt(backpack, "ToolsInventory");
            if (contents.m_128441_("Size")) {
                contents.m_128473_("Size");
            }
            this.tools.deserializeNBT(contents);
        }
    }

    public void setStarterUpgrade(ItemStack upgrade) {
        if (this.levelAccessor == null) {
            return;
        }
        if (upgrade.m_41720_().m_245993_(this.levelAccessor.m_246046_())) {
            this.upgrades.setStackInSlot(0, upgrade);
            this.upgradesTracker.setStackInSlot(0, upgrade);
            if (upgrade.m_41720_() instanceof TanksUpgradeItem) {
                this.setRenderInfo(TanksUpgradeItem.writeToRenderData().compoundTag());
            }
        }
    }

    public ItemStackHandler getStorage() {
        return this.inventory;
    }

    public ItemStackHandler getUpgrades() {
        return this.upgrades;
    }

    public ItemStackHandler getTools() {
        return this.tools;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public SlotPositioner getSlotPositioner() {
        return this.slotPositioner;
    }

    public List<Integer> getUnsortableSlots() {
        return NbtHelper.getOrDefault(this.stack, "UnsortableSlots", List.of());
    }

    public List<Pair<Integer, Pair<ItemStack, Boolean>>> getMemorySlots() {
        return NbtHelper.getOrDefault(this.stack, "MemorySlots", List.of());
    }

    public byte getScreenID() {
        return this.screenID;
    }

    public void setUnsortableSlots(List<Integer> unsortables) {
        NbtHelper.set(this.stack, "UnsortableSlots", unsortables);
        this.saveHandler.run();
    }

    public void setMemorySlots(List<Pair<Integer, Pair<ItemStack, Boolean>>> memory) {
        NbtHelper.set(this.stack, "MemorySlots", memory);
        this.saveHandler.run();
    }

    public boolean showToolSlots() {
        return NbtHelper.getOrDefault(this.stack, "ShowToolSlots", false);
    }

    public void setShowToolSlots(boolean show) {
        NbtHelper.set(this.stack, "ShowToolSlots", show);
        this.saveHandler.run();
    }

    public boolean tanksVisible() {
        if (NbtHelper.has(this.stack, "RenderInfo")) {
            return ((RenderInfo)NbtHelper.get(this.stack, "RenderInfo")).hasTanks();
        }
        return this.getUpgradeManager().tanksUpgrade.isPresent();
    }

    public int getBackpackTankCapacity() {
        return this.tanksCapacity;
    }

    public void setBackpackPos(BlockPos pos) {
        this.backpackPos = pos;
    }

    public BlockPos getBackpackPos() {
        return this.backpackPos;
    }

    public void setBackpackTankCapacity() {
        SlotPositioner pos = this.getSlotPositioner();
        int rows = pos.getRows() + (pos.isExtended() ? 2 : 0);
        this.tanksCapacity = Tiers.of(NbtHelper.getOrDefault(this.stack, "Tier", 0)).getTankCapacityPerRow() * rows;
    }

    public void setRenderInfo(CompoundTag compound) {
        NbtHelper.set(this.stack, "RenderInfo", new RenderInfo(compound));
        this.saveHandler.run();
    }

    public void removeRenderInfo() {
        NbtHelper.set(this.stack, "RenderInfo", new RenderInfo(new CompoundTag()));
        this.saveHandler.run();
    }

    public boolean isAbilityEnabled() {
        return NbtHelper.getOrDefault(this.stack, "AbilityEnabled", (Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.forceAbilityEnabled.get());
    }

    public void setAbilityEnabled(boolean enabled) {
        NbtHelper.set(this.stack, "AbilityEnabled", enabled);
        this.saveHandler.run();
        this.abilityHandler.run();
    }

    public boolean hasSleepingBag() {
        return NbtHelper.has(this.stack, "SleepingBagColor");
    }

    public int getSleepingBagColor() {
        return NbtHelper.getOrDefault(this.stack, "SleepingBagColor", DyeColor.RED.m_41060_());
    }

    public void setSleepingBagColor(int colorId) {
        NbtHelper.set(this.stack, "SleepingBagColor", colorId);
    }

    public boolean isOwner(Player player) {
        if (this.getBackpackOwner() != null) {
            return this.getBackpackOwner().m_19879_() == player.m_19879_();
        }
        return true;
    }

    public void setVisibility(boolean visibility) {
        NbtHelper.set(this.stack, "IsVisible", visibility);
        this.saveHandler.run();
        this.sendDataToClients("IsVisible");
    }

    public int getCooldown() {
        return NbtHelper.getOrDefault(this.stack, "Cooldown", 0);
    }

    public void setCooldown(int cooldownInSeconds) {
        NbtHelper.set(this.stack, "Cooldown", cooldownInSeconds);
        this.saveHandler.run();
        this.sendDataToClients("Cooldown");
    }

    public void decreaseCooldown() {
        if (this.getCooldown() > 0) {
            int currentCooldown = this.getCooldown();
            NbtHelper.set(this.stack, "Cooldown", currentCooldown - 1);
            this.saveHandler.run();
        }
    }

    public void setAbilityState() {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() || !BackpackAbilities.ALLOWED_ABILITIES.contains(this.getBackpackStack().m_41720_())) {
            if (NbtHelper.getOrDefault(this.getBackpackStack(), "AbilityEnabled", false).booleanValue()) {
                this.setAbilityEnabled(false);
            }
            return;
        }
        if (!NbtHelper.has(this.getBackpackStack(), "AbilityEnabled") && ((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.forceAbilityEnabled.get()).booleanValue()) {
            this.setAbilityEnabled(true);
        }
    }

    public boolean canUpgradeTick() {
        return NbtHelper.has(this.stack, "UpgradeTickInterval");
    }

    public boolean hasTickingUpgrade() {
        return this.upgradeManager.hasTickingUpgrade();
    }

    public int getUpgradeTickInterval() {
        return NbtHelper.getOrDefault(this.stack, "UpgradeTickInterval", 100);
    }

    public void setUpgradeTickInterval(int ticks) {
        NbtHelper.set(this.stack, "UpgradeTickInterval", ticks);
    }

    public void removeUpgradeTickInterval() {
        NbtHelper.remove(this.stack, "UpgradeTickInterval");
    }

    public void sendDataToClients(String ... keys) {
        if (this.getScreenID() == 3) {
            return;
        }
        if (this.getScreenID() == 1 && !this.getPlayersUsing().stream().filter(p -> !p.m_9236_().f_46443_).toList().isEmpty()) {
            CompoundTag builder = new CompoundTag();
            for (String key : keys) {
                if (!this.getBackpackStack().m_41783_().m_128441_(key)) continue;
                builder.m_128365_(key, this.getBackpackStack().m_41783_().m_128423_(key));
            }
            PacketDistributorHelper.sendToPlayer((ServerPlayer)this.getPlayersUsing().get(0), new ClientboundSyncItemStackPacket(this.getPlayersUsing().get(0).m_19879_(), this.getScreenID() == 2 ? -1 : this.getPlayersUsing().get((int)0).m_150109_().f_35977_, this.getBackpackStack(), builder));
            return;
        }
        if (TravelersBackpack.enableIntegration() && this.getScreenID() == 2 && !this.getPlayersUsing().stream().filter(p -> !p.m_9236_().f_46443_).toList().isEmpty()) {
            for (Player player : this.getPlayersUsing()) {
                CompoundTag builder = new CompoundTag();
                for (String key : keys) {
                    if (!this.getBackpackStack().m_41783_().m_128441_(key)) continue;
                    builder.m_128365_(key, this.getBackpackStack().m_41783_().m_128423_(key));
                }
                PacketDistributorHelper.sendToPlayer((ServerPlayer)player, new ClientboundSyncItemStackPacket(player.m_19879_(), -1, this.getBackpackStack(), builder));
            }
            return;
        }
        if (this.getUpgradeManager().getWrapper().getBackpackOwner() != null) {
            CompoundTag builder = new CompoundTag();
            ItemStack serverBackpack = CapabilityUtils.getWearingBackpack(this.getBackpackOwner());
            for (String key : keys) {
                if (!serverBackpack.m_41783_().m_128441_(key)) continue;
                builder.m_128365_(key, serverBackpack.m_41783_().m_128423_(key));
            }
            CapabilityUtils.getCapability(this.getUpgradeManager().getWrapper().getBackpackOwner()).ifPresent(data -> data.synchronise(builder));
        }
    }

    public Optional<Pair<Integer, Pair<ItemStack, Boolean>>> getMemorizedSlot(int slot) {
        return this.getMemorySlots().stream().filter(pair -> (Integer)pair.getFirst() == slot).findFirst();
    }

    private ItemStackHandler createHandler(int size, final byte dataId) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                BackpackWrapper.this.setSlotChanged(slot, this.getStackInSlot(slot), dataId);
                if (dataId == 2) {
                    BackpackWrapper.this.sendDataToClients("ToolsInventory");
                }
                BackpackWrapper.this.saveHandler.run();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (dataId == 2) {
                    return ToolSlotItemHandler.isValid(stack);
                }
                return BackpackSlotItemHandler.isItemValid(stack);
            }
        };
    }

    public void setSlotChanged(int index, ItemStack stack, byte dataId) {
        switch (dataId) {
            case 0: {
                NbtHelper.update(this.stack, "Inventory", this.getStorage().getSlots(), index, stack);
                break;
            }
            case 1: {
                NbtHelper.update(this.stack, "Upgrades", this.getUpgrades().getSlots(), index, stack);
                break;
            }
            case 2: {
                NbtHelper.update(this.stack, "ToolsInventory", this.getTools().getSlots(), index, stack);
            }
        }
    }

    public void updateMinimalTickInterval(ItemStack newStack) {
        if (this.getScreenID() == 2 && (newStack.m_41720_() == ModItems.FEEDING_UPGRADE.get() || newStack.m_41720_() == ModItems.MAGNET_UPGRADE.get())) {
            if (NbtHelper.getOrDefault(newStack, "UpgradeEnabled", true).booleanValue()) {
                int minimalInterval = 100;
                for (int i = 0; i < this.upgrades.getSlots(); ++i) {
                    ItemStack upgrade = this.upgrades.getStackInSlot(i);
                    if (!NbtHelper.has(upgrade, "Cooldown")) continue;
                    minimalInterval = Math.min(minimalInterval, (Integer)NbtHelper.get(upgrade, "Cooldown"));
                }
                if (!this.canUpgradeTick() || this.getUpgradeTickInterval() != minimalInterval) {
                    this.setUpgradeTickInterval(minimalInterval);
                }
            } else if (this.canUpgradeTick() && !this.hasTickingUpgrade()) {
                this.removeUpgradeTickInterval();
            }
        }
    }

    private ItemStackHandler createUpgradeHandler(int size, final byte dataId) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                BackpackWrapper.this.setSlotChanged(slot, this.getStackInSlot(slot), dataId);
                if (!BackpackWrapper.this.getPlayersUsing().isEmpty()) {
                    BackpackWrapper.this.getUpgradeManager().detectedChange(BackpackWrapper.this.upgradesTracker, slot);
                }
                BackpackWrapper.this.updateMinimalTickInterval(this.getStackInSlot(slot));
                BackpackWrapper.this.saveHandler.run();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                boolean isValid = true;
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (this.getStackInSlot(i).m_41720_() != stack.m_41720_()) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) {
                    return false;
                }
                if (stack.m_41720_() instanceof TanksUpgradeItem) {
                    isValid = TanksUpgradeItem.canBePutInBackpack(BackpackWrapper.this.getBackpackTankCapacity(), stack);
                }
                if (!this.checkIfUpgradeValid(stack)) {
                    isValid = false;
                }
                return isValid;
            }

            public boolean checkIfUpgradeValid(ItemStack upgradeStack) {
                Item item = upgradeStack.m_41720_();
                if (item instanceof UpgradeItem) {
                    Player player;
                    UpgradeItem upgradeItem = (UpgradeItem)item;
                    Player player2 = player = BackpackWrapper.this.getPlayersUsing().isEmpty() ? null : BackpackWrapper.this.getPlayersUsing().get(0);
                    if (player == null) {
                        return false;
                    }
                    if (upgradeItem.m_245993_(player.m_9236_().m_246046_())) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static boolean isSizeInitialized(ItemStack stack) {
        return NbtHelper.has(stack, "StorageSlots") && NbtHelper.has(stack, "UpgradeSlots") && NbtHelper.has(stack, "ToolSlots");
    }

    public static void initializeSize(ItemStack stack) {
        Tiers.Tier tier = Tiers.LEATHER;
        if (NbtHelper.has(stack, "Tier")) {
            tier = Tiers.of((Integer)NbtHelper.get(stack, "Tier"));
        }
        if (!NbtHelper.has(stack, "StorageSlots")) {
            NbtHelper.set(stack, "StorageSlots", tier.getStorageSlots());
        }
        if (!NbtHelper.has(stack, "UpgradeSlots")) {
            NbtHelper.set(stack, "UpgradeSlots", tier.getUpgradeSlots());
        }
        if (!NbtHelper.has(stack, "ToolSlots")) {
            NbtHelper.set(stack, "ToolSlots", tier.getToolSlots());
        }
    }

    public void requestMenuAndScreenUpdate(boolean onlyTab) {
        this.requestMenuUpdate(onlyTab);
        this.requestScreenUpdate();
    }

    public void requestMenuUpdate(boolean onlyTab) {
        if (!this.getPlayersUsing().isEmpty() && !this.getPlayersUsing().stream().filter(player -> player.f_36096_ instanceof BackpackBaseMenu).toList().isEmpty()) {
            for (Player player2 : this.getPlayersUsing().stream().filter(player -> player.f_36096_ instanceof BackpackBaseMenu).toList()) {
                if (onlyTab) {
                    ((BackpackBaseMenu)player2.f_36096_).updateModifiableSlots();
                    continue;
                }
                ((BackpackBaseMenu)player2.f_36096_).updateSlots();
            }
        }
    }

    public void requestScreenUpdate() {
        Screen screen;
        if (!this.getPlayersUsing().isEmpty() && !this.getPlayersUsing().stream().filter(player -> player.m_9236_().f_46443_).toList().isEmpty() && (screen = Minecraft.m_91087_().f_91080_) instanceof BackpackScreen) {
            BackpackScreen screen2 = (BackpackScreen)screen;
            screen2.updateScreen();
        }
    }

    public static void tickForBlockEntity(BackpackBlockEntity backpackBlockEntity) {
        BackpackWrapper wrapper = backpackBlockEntity.getWrapper();
        if (wrapper != DUMMY && wrapper.isAbilityEnabled() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, wrapper.getBackpackStack())) {
            boolean decreaseCooldown = BackpackAbilities.ABILITIES.abilityTickBlock(backpackBlockEntity);
            if (wrapper.getCooldown() > 0 && decreaseCooldown) {
                wrapper.decreaseCooldown();
            }
        }
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(Player player, ItemStack backpack) {
        if (CapabilityUtils.isWearingBackpack(player)) {
            BackpackItemMenu menu;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof BackpackItemMenu && (menu = (BackpackItemMenu)abstractContainerMenu).getWrapper().getScreenID() == 2) {
                return menu.getWrapper();
            }
            for (Player otherPlayer : player.m_9236_().m_6907_()) {
                BackpackItemMenu menu2;
                AbstractContainerMenu abstractContainerMenu2 = otherPlayer.f_36096_;
                if (!(abstractContainerMenu2 instanceof BackpackItemMenu) || !(menu2 = (BackpackItemMenu)abstractContainerMenu2).getWrapper().isOwner(player) || menu2.getWrapper().getScreenID() != 2) continue;
                return menu2.getWrapper();
            }
            return new BackpackWrapper(backpack, 2, player, (LevelAccessor)player.m_9236_());
        }
        return null;
    }

    public static void tick(ItemStack stack, Player player, boolean integration) {
        if (!integration && TravelersBackpack.enableIntegration()) {
            return;
        }
        if (player.m_6084_() && CapabilityUtils.isWearingBackpack(player)) {
            int upgradeTicks;
            BackpackWrapper wrapper;
            int ticks = (int)player.m_9236_().m_46467_();
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, CapabilityUtils.getWearingBackpack(player))) {
                if (BackpackAbilities.isAbilityEnabledInConfig(stack) && NbtHelper.getOrDefault(stack, "AbilityEnabled", (Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.forceAbilityEnabled.get()).booleanValue()) {
                    boolean decreaseCooldown = BackpackAbilities.ABILITIES.abilityTick(stack, player);
                    if (NbtHelper.getOrDefault(stack, "Cooldown", 0) > 0 && ticks % 100 == 0 && decreaseCooldown) {
                        wrapper = CapabilityUtils.getBackpackWrapper(player, stack);
                        int cooldown = wrapper.getCooldown();
                        if (player.m_9236_().f_46443_) {
                            return;
                        }
                        wrapper.setCooldown(cooldown - 100);
                    }
                }
            } else if (NbtHelper.getOrDefault(stack, "AbilityEnabled", false).booleanValue()) {
                NbtHelper.set(stack, "AbilityEnabled", false);
            }
            if (NbtHelper.has(stack, "UpgradeTickInterval") && ticks % (upgradeTicks = ((Integer)NbtHelper.get(stack, "UpgradeTickInterval")).intValue()) == 0) {
                wrapper = CapabilityUtils.getBackpackWrapper(player, stack);
                for (int i = 0; i < wrapper.getUpgradeManager().mappedUpgrades.size(); ++i) {
                    Optional<? extends IUpgrade> upgrade = wrapper.getUpgradeManager().mappedUpgrades.get(i);
                    if (upgrade == null || !upgrade.isPresent() || !(upgrade.get() instanceof ITickableUpgrade)) continue;
                    ((ITickableUpgrade)((Object)upgrade.get())).tick(player, player.m_9236_(), player.m_20183_(), ticks);
                }
            }
        }
    }

    public void converter(ItemStack stack, int storageSlots, int toolSlots) {
        if (NbtHelper.has(stack, "Inventory") && storageSlots != ((NonNullList)NbtHelper.get(stack, "Inventory")).size()) {
            stack.m_41783_().m_128365_("Inventory", (Tag)NbtHelper.expandTag(stack, "Inventory", storageSlots));
        }
        if (NbtHelper.has(stack, "ToolsInventory") && toolSlots != ((NonNullList)NbtHelper.get(stack, "ToolsInventory")).size()) {
            stack.m_41783_().m_128365_("ToolsInventory", (Tag)NbtHelper.expandTag(stack, "ToolsInventory", toolSlots));
        }
        if (NbtHelper.has(stack, "LeftTank") || NbtHelper.has(stack, "RightTank")) {
            FluidStack fluidStack;
            CompoundTag oldTank = NbtHelper.has(stack, "LeftTank") ? stack.m_41783_().m_128469_("LeftTank") : new CompoundTag();
            CompoundTag oldTank2 = NbtHelper.has(stack, "RightTank") ? stack.m_41783_().m_128469_("RightTank") : new CompoundTag();
            FluidStack leftFluidStack = FluidStack.EMPTY;
            FluidStack rightFluidStack = FluidStack.EMPTY;
            if (!oldTank.m_128456_() && !(fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)oldTank)).isEmpty()) {
                leftFluidStack = fluidStack;
            }
            if (!oldTank2.m_128456_() && !(fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)oldTank2)).isEmpty()) {
                rightFluidStack = fluidStack;
            }
            ItemStack oldTanks = ((TanksUpgradeItem)((Object)ModItems.TANKS_UPGRADE.get())).m_7968_();
            NbtHelper.set(oldTanks, "Fluids", new Fluids(leftFluidStack, rightFluidStack));
            this.setStarterUpgrade(oldTanks);
            stack.m_41783_().m_128473_("LeftTank");
            stack.m_41783_().m_128473_("RightTank");
        }
    }
}

