/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.IBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.UpgradeSlot;
import com.tiviacz.travelersbackpack.client.screens.buttons.AbilitySliderButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.EquipButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.SleepingBagButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.UnequipButton;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.SortingButtons;
import com.tiviacz.travelersbackpack.client.screens.widgets.ToolSlotsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.network.ServerboundSorterPacket;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class BackpackScreen
extends AbstractContainerScreen<BackpackBaseMenu>
implements MenuAccess<BackpackBaseMenu>,
IBackpackScreen {
    public static final ResourceLocation BACKGROUND_11 = new ResourceLocation("travelersbackpack", "textures/gui/background_11.png");
    public static final ResourceLocation BACKGROUND_9 = new ResourceLocation("travelersbackpack", "textures/gui/background_9.png");
    public static final ResourceLocation SLOTS = new ResourceLocation("travelersbackpack", "textures/gui/slots.png");
    public static final ResourceLocation TANKS = new ResourceLocation("travelersbackpack", "textures/gui/tanks.png");
    public static final ResourceLocation ICONS = new ResourceLocation("travelersbackpack", "textures/gui/icons.png");
    public static final ResourceLocation TABS = new ResourceLocation("travelersbackpack", "textures/gui/tabs.png");
    public static final int TOP_BAR_OFFSET = 7;
    public int slotCount;
    public boolean tanksVisible;
    public int upgradeSlotCount;
    public List<UpgradeSlot> upgradeSlots = new ArrayList<UpgradeSlot>();
    boolean upgradesInitialized = false;
    boolean wider = false;
    public List<IButton> buttons = new ArrayList<IButton>();
    public SortingButtons sortingButtons;
    public ToolSlotsWidget toolSlotsWidget;
    public SettingsWidget settingsWidget;
    private final BackpackWrapper wrapper;
    public int warningTicks = 0;

    public BackpackScreen(BackpackBaseMenu backpackMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)backpackMenu, inventory, component);
        this.wrapper = backpackMenu.getWrapper();
        this.recalculate();
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public Player getScreenPlayer() {
        return ((BackpackBaseMenu)this.m_6262_()).player;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initButtons();
        this.initWidgets();
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.warningTicks > 0) {
            --this.warningTicks;
        }
    }

    public void recalculate() {
        boolean wideTexture;
        this.m_169413_();
        this.upgradeSlots.clear();
        this.slotCount = this.getWrapper().getStorage().getSlots();
        this.tanksVisible = this.getWrapper().tanksVisible();
        this.upgradeSlotCount = this.getWrapper().getUpgrades().getSlots();
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.wider = wideTexture = this.slotCount > 81;
        int playerInventoryHeight = 96;
        this.f_97726_ = wideTexture ? (this.tanksVisible ? 256 : 212) : (this.tanksVisible ? 220 : 176);
        this.f_97727_ = 7 + this.calculateSlotHeight(wideTexture) + playerInventoryHeight;
        this.f_97731_ = this.f_97727_ - 93;
        this.f_97730_ = 8;
        if (this.tanksVisible) {
            this.f_97730_ += 22;
        }
        if (wideTexture) {
            this.f_97730_ += 18;
        }
    }

    public int getImageHeight() {
        return this.f_97727_;
    }

    public int getWidthAdditions() {
        int addition = 0;
        if (this.tanksVisible) {
            addition += 22;
        }
        if (this.wider) {
            addition += 18;
        }
        return addition;
    }

    public void updateScreen() {
        this.recalculate();
        this.m_7856_();
    }

    public void renderInventoryBackground(GuiGraphics guiGraphics, int x, int y, ResourceLocation texture, int xSize, int slotsHeight) {
        int halfSlotHeight = slotsHeight / 2;
        guiGraphics.m_280218_(texture, x, y, 0, 0, xSize, 7 + halfSlotHeight);
        int playerInventoryHeight = 97;
        guiGraphics.m_280218_(texture, x, y + 7 + halfSlotHeight, 0, 256 - (playerInventoryHeight + halfSlotHeight), xSize, playerInventoryHeight + halfSlotHeight);
    }

    public void renderSlots(GuiGraphics guiGraphics, int x, int y, int slotCount, int slotsInRow) {
        int lastSlotRow = slotCount % slotsInRow;
        int fullRows = slotCount / slotsInRow;
        guiGraphics.m_280218_(SLOTS, x, y, 0, 0, slotsInRow * 18, fullRows * 18);
        if (lastSlotRow > 0) {
            guiGraphics.m_280218_(SLOTS, x, y + fullRows * 18, 0, fullRows * 18, lastSlotRow * 18, 18);
        }
    }

    public void renderScreen(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.renderUpgradeSlots(guiGraphics, x, y);
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));
        boolean wideTexture = this.slotCount > 81;
        int inventoryXOffset = this.tanksVisible ? 22 : 0;
        this.renderInventoryBackground(guiGraphics, x + inventoryXOffset, y, wideTexture ? BACKGROUND_11 : BACKGROUND_9, this.f_97726_, this.calculateSlotHeight(wideTexture));
        int slotsXOffset = 7;
        if (this.tanksVisible) {
            slotsXOffset = 29;
            int halfTankHeight = this.calculateSlotHeight(wideTexture) / 2;
            int tanksHeight = 90;
            int uOffset = 56;
            int posOffset = 193;
            if (wideTexture) {
                uOffset = 0;
                posOffset = 229;
            }
            guiGraphics.m_280218_(TANKS, x, y, 0, 0, 27, 7 + halfTankHeight);
            guiGraphics.m_280218_(TANKS, x, y + 7 + halfTankHeight, uOffset, 256 - (tanksHeight + halfTankHeight + 7), 27, tanksHeight + halfTankHeight + 7);
            guiGraphics.m_280218_(TANKS, x + posOffset, y, uOffset + 28, 0, 27, 7 + halfTankHeight);
            guiGraphics.m_280218_(TANKS, x + posOffset, y + 7 + halfTankHeight, uOffset + 28, 256 - (tanksHeight + halfTankHeight + 7), 27, tanksHeight + halfTankHeight + 7);
        }
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        this.renderSlots(guiGraphics, x + slotsXOffset, y + 7, this.slotCount, wideTexture ? 11 : 9);
    }

    public int calculateSlotHeight(boolean wider) {
        int rowSlots = wider ? 11 : 9;
        int rows = (int)Math.ceil((double)this.slotCount / (double)rowSlots);
        return rows * 18;
    }

    public void renderUpgradeSlots(GuiGraphics guiGraphics, int x, int y) {
        for (UpgradeSlot slot : this.upgradeSlots) {
            slot.render(guiGraphics, x, y);
        }
    }

    public void initializeUpgradeSlots() {
        for (int i = 0; i < this.upgradeSlotCount; ++i) {
            int x = ((BackpackBaseMenu)this.f_97732_).upgradeSlot.get((int)i).f_40220_ - 4;
            int y = ((BackpackBaseMenu)this.f_97732_).upgradeSlot.get((int)i).f_40221_ - 4;
            this.upgradeSlots.add(new UpgradeSlot(this.getWrapper().getUpgrades(), new Point(this.getGuiLeft() + x, this.getGuiTop() + y), i, x, y, ((BackpackBaseMenu)this.f_97732_).upgradeSlot.get((int)i).isHidden));
        }
        this.upgradesInitialized = true;
    }

    @Override
    public Font getFont() {
        return this.f_96547_;
    }

    public void initWidgets() {
        this.settingsWidget = new SettingsWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4), false);
        this.m_142416_(this.settingsWidget);
        int xPos = this.f_97735_ + (this.wider ? 27 : 9) + (this.tanksVisible ? 22 : (this.wider ? 0 : 18));
        this.sortingButtons = new SortingButtons(this, new Point(xPos, this.f_97736_ - 10), 50, 13);
        this.m_142416_(this.sortingButtons);
        this.toolSlotsWidget = new ToolSlotsWidget(this, new Point(this.f_97735_ + 7, this.f_97736_ - 15));
        this.m_142416_(this.toolSlotsWidget);
        UpgradeManager manager = this.getWrapper().getUpgradeManager();
        for (Optional<? extends IUpgrade> upgrade : manager.mappedUpgrades.values()) {
            upgrade.ifPresent(loadedUpgrade -> {
                int x = ((BackpackBaseMenu)this.f_97732_).upgradeSlot.get((int)this.getWrapper().getUpgradeManager().slotMappedUpgrades.get((Object)upgrade).intValue()).f_40220_ - 4;
                int y = ((BackpackBaseMenu)this.f_97732_).upgradeSlot.get((int)this.getWrapper().getUpgradeManager().slotMappedUpgrades.get((Object)upgrade).intValue()).f_40221_ - 4;
                this.m_142416_(loadedUpgrade.createWidget(this, x, y));
            });
        }
        this.initializeUpgradeSlots();
    }

    public void initButtons() {
        this.buttons.clear();
        if (this.getWrapper().getScreenID() == 1) {
            this.buttons.add(new EquipButton(this));
        }
        if (this.getWrapper().getScreenID() == 2 && this.getWrapper().isOwner(((BackpackBaseMenu)this.m_6262_()).player)) {
            this.buttons.add(new UnequipButton(this));
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.getWrapper().getBackpackStack())) {
                this.buttons.add(new AbilitySliderButton(this, false));
            }
        }
        if (this.getWrapper().getScreenID() == 3) {
            this.buttons.add(new SleepingBagButton(this));
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.getWrapper().getBackpackStack())) {
                this.buttons.add(new AbilitySliderButton(this, true));
            }
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.buttons.forEach(button -> button.render(guiGraphics, mouseX, mouseY, partialTicks));
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        this.buttons.forEach(button -> button.renderTooltip(guiGraphics, mouseX, mouseY));
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
        if (this.warningTicks > 0) {
            if (!(((BackpackBaseMenu)this.f_97732_).m_142621_().m_41720_() instanceof TanksUpgradeItem)) {
                this.warningTicks = 0;
            }
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(Component.m_237115_((String)"screen.travelersbackpack.cant_apply_upgrade"));
            tooltip.add(Component.m_237115_((String)"screen.travelersbackpack.too_much_fluid"));
            FluidStack leftFluidStack = TanksUpgradeItem.getLeftFluidStack(((BackpackBaseMenu)this.f_97732_).m_142621_());
            FluidStack rightFluidStack = TanksUpgradeItem.getRightFluidStack(((BackpackBaseMenu)this.f_97732_).m_142621_());
            if (!leftFluidStack.isEmpty() && leftFluidStack.getAmount() > this.getWrapper().getBackpackTankCapacity()) {
                tooltip.add(this.crateFluidWarning(leftFluidStack, this.getWrapper().getBackpackTankCapacity()));
            }
            if (!rightFluidStack.isEmpty() && rightFluidStack.getAmount() > this.getWrapper().getBackpackTankCapacity()) {
                tooltip.add(this.crateFluidWarning(rightFluidStack, this.getWrapper().getBackpackTankCapacity()));
            }
            guiGraphics.m_280677_(this.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public Component crateFluidWarning(FluidStack fluidStack, int backpackCapacity) {
        return Component.m_237113_((String)(fluidStack.getFluid().getFluidType().getDescription().getString() + " " + fluidStack.getAmount() + "/" + backpackCapacity + "mB")).m_130940_(ChatFormatting.RED);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderScreen(guiGraphics, x, y, mouseX, mouseY, partialTicks);
        this.drawUnsortableSlots(guiGraphics);
        this.drawMemorySlots(guiGraphics);
    }

    public void drawUnsortableSlots(GuiGraphics guiGraphics) {
        if (!this.getWrapper().getUnsortableSlots().isEmpty()) {
            this.getWrapper().getUnsortableSlots().forEach(i -> guiGraphics.m_280218_(ICONS, this.getGuiLeft() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40220_, this.getGuiTop() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40221_, 25, 55, 16, 16));
        }
    }

    public void drawMemorySlots(GuiGraphics guiGraphics) {
        if (!this.getWrapper().getMemorySlots().isEmpty()) {
            this.getWrapper().getMemorySlots().forEach(pair -> {
                if (((BackpackBaseMenu)this.m_6262_()).m_38853_((Integer)pair.getFirst()).m_7993_().m_41619_()) {
                    ItemStack itemstack = (ItemStack)((Pair)pair.getSecond()).getFirst();
                    guiGraphics.m_280203_(itemstack, this.getGuiLeft() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_);
                    guiGraphics.m_285944_(RenderType.m_285811_(), this.getGuiLeft() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, this.getGuiLeft() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_ + 16, this.getGuiTop() + ((BackpackBaseMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_ + 16, 0x30FFFFFF);
                }
            });
        }
    }

    protected boolean m_7467_(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        if (!((BackpackBaseMenu)this.f_97732_).m_142621_().m_41619_()) {
            for (GuiEventListener widget : this.m_6702_()) {
                WidgetBase base;
                if (!(widget instanceof WidgetBase) || !(base = (WidgetBase)widget).m_5953_(pMouseX, pMouseY)) continue;
                return false;
            }
        }
        return pMouseX < (double)pGuiLeft || pMouseY < (double)pGuiTop || pMouseX >= (double)(pGuiLeft + this.f_97726_) || pMouseY >= (double)(pGuiTop + this.f_97727_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.buttons.forEach(b -> b.mouseClicked(mouseX, mouseY, button));
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public void playUIClickSound() {
        ((BackpackBaseMenu)this.f_97732_).getPlayerInventory().f_35978_.m_9236_().m_5594_(((BackpackBaseMenu)this.f_97732_).getPlayerInventory().f_35978_, ((BackpackBaseMenu)this.f_97732_).getPlayerInventory().f_35978_.m_20183_(), (SoundEvent)SoundEvents.f_12490_.m_203334_(), SoundSource.MASTER, 0.25f, 1.0f);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (ModClientEventHandler.SORT_BACKPACK.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            PacketDistributorHelper.sendToServer(new ServerboundSorterPacket(this.getWrapper().getScreenID(), 0, BackpackDeathHelper.isShiftPressed()));
            this.playUIClickSound();
            return true;
        }
        if (ModClientEventHandler.OPEN_BACKPACK.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            LocalPlayer playerEntity = this.getMinecraft().f_91074_;
            if (playerEntity != null) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public static void displayTanksUpgradeWarning(Player player) {
        Screen screen;
        if (player.m_9236_().f_46443_ && (screen = Minecraft.m_91087_().f_91080_) instanceof BackpackScreen) {
            BackpackScreen screen2 = (BackpackScreen)screen;
            screen2.warningTicks = 60;
        }
    }
}

