/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.math;

import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public record XZ(int x, int z) {
    public static XZ of(int x, int z) {
        return new XZ(x, z);
    }

    public static XZ of(long singleLong) {
        return XZ.of((int)singleLong, (int)(singleLong >> 32));
    }

    public static XZ of(ChunkPos pos) {
        return XZ.of(pos.f_45578_, pos.f_45579_);
    }

    public static XZ chunkFromBlock(int x, int z) {
        return XZ.of(x >> 4, z >> 4);
    }

    public static XZ chunkFromBlock(Vec3i pos) {
        return XZ.chunkFromBlock(pos.m_123341_(), pos.m_123343_());
    }

    public static XZ regionFromChunk(int x, int z) {
        return XZ.of(x >> 5, z >> 5);
    }

    public static XZ regionFromChunk(ChunkPos p) {
        return XZ.of(p.f_45578_ >> 5, p.f_45579_ >> 5);
    }

    public static XZ regionFromBlock(int x, int z) {
        return XZ.of(x >> 9, z >> 9);
    }

    public static XZ regionFromBlock(Vec3i pos) {
        return XZ.regionFromBlock(pos.m_123341_(), pos.m_123343_());
    }

    @Override
    public int hashCode() {
        int x1 = 1664525 * this.x + 1013904223;
        int z1 = 1664525 * (this.z ^ 0xDEADBEEF) + 1013904223;
        return x1 ^ z1;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XZ)) {
            return false;
        }
        XZ p = (XZ)o;
        return this.x == p.x && this.z == p.z;
    }

    @Override
    public String toString() {
        return "[" + this.x + ", " + this.z + "]";
    }

    public ChunkDimPos dim(ResourceKey<Level> type) {
        return new ChunkDimPos(type, this.x, this.z);
    }

    public ChunkDimPos dim(Level world) {
        return this.dim((ResourceKey<Level>)world.m_46472_());
    }

    public XZ offset(int ox, int oz) {
        return XZ.of(this.x + ox, this.z + oz);
    }

    public long toLong() {
        return ChunkPos.m_45589_((int)this.x, (int)this.z);
    }

    public String toRegionString() {
        return String.format("%05X-%05X", this.x + 60000, this.z + 60000);
    }
}

