/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;

public class SchematicWorldRefresher
implements IRangeChangeListener {
    public static final SchematicWorldRefresher INSTANCE = new SchematicWorldRefresher();
    private final Minecraft mc = Minecraft.m_91087_();

    public void updateAll() {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && this.mc.f_91073_ != null) {
            DataManager.getSchematicPlacementManager().setVisibleSubChunksNeedsUpdate();
            int minY = world.m_141937_();
            int maxY = world.m_151558_() - 1;
            this.updateBetweenY(minY, maxY);
        }
    }

    public void updateBetweenX(int minX, int maxX) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && this.mc.f_91073_ != null) {
            DataManager.getSchematicPlacementManager().setVisibleSubChunksNeedsUpdate();
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            int cxMin = Math.min(minX, maxX) >> 4;
            int cxMax = Math.max(minX, maxX) >> 4;
            for (ChunkSchematic chunk : schematicChunks.values()) {
                ChunkPos pos = chunk.m_7697_();
                if (pos.f_45578_ < cxMin || pos.f_45578_ > cxMax || chunk.m_6430_() || !WorldUtils.isClientChunkLoaded(this.mc.f_91073_, pos.f_45578_, pos.f_45579_)) continue;
                world.scheduleChunkRenders(pos.f_45578_, pos.f_45579_);
            }
        }
    }

    public void updateBetweenY(int minY, int maxY) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && this.mc.f_91073_ != null) {
            DataManager.getSchematicPlacementManager().setVisibleSubChunksNeedsUpdate();
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            for (ChunkSchematic chunk : schematicChunks.values()) {
                ChunkPos pos = chunk.m_7697_();
                if (chunk.m_6430_() || !WorldUtils.isClientChunkLoaded(this.mc.f_91073_, pos.f_45578_, pos.f_45579_)) continue;
                world.scheduleChunkRenders(pos.f_45578_, pos.f_45579_);
            }
        }
    }

    public void updateBetweenZ(int minZ, int maxZ) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && this.mc.f_91073_ != null) {
            DataManager.getSchematicPlacementManager().setVisibleSubChunksNeedsUpdate();
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            int czMin = Math.min(minZ, maxZ) >> 4;
            int czMax = Math.max(minZ, maxZ) >> 4;
            for (ChunkSchematic chunk : schematicChunks.values()) {
                ChunkPos pos = chunk.m_7697_();
                if (pos.f_45579_ < czMin || pos.f_45579_ > czMax || chunk.m_6430_() || !WorldUtils.isClientChunkLoaded(this.mc.f_91073_, pos.f_45578_, pos.f_45579_)) continue;
                world.scheduleChunkRenders(pos.f_45578_, pos.f_45579_);
            }
        }
    }

    public void markSchematicChunksForRenderUpdate(int chunkX, int chunkZ) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && this.mc.f_91073_ != null && world.getChunkProvider().m_5563_(chunkX, chunkZ) && WorldUtils.isClientChunkLoaded(this.mc.f_91073_, chunkX, chunkZ)) {
            world.scheduleChunkRenders(chunkX, chunkZ);
        }
    }

    public void markSchematicChunkForRenderUpdate(BlockPos pos) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && this.mc.f_91073_ != null) {
            int chunkX = pos.m_123341_() >> 4;
            int chunkZ = pos.m_123343_() >> 4;
            Litematica.debugLog("SchematicWorldRefresher#markSchematicChunkForRenderUpdate({}, {})", chunkX, chunkZ);
            if (world.getChunkProvider().m_5563_(chunkX, chunkZ) && WorldUtils.isClientChunkLoaded(this.mc.f_91073_, chunkX, chunkZ)) {
                world.scheduleChunkRenders(chunkX, chunkZ);
            }
        }
    }
}

