/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.Litematica;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.phys.Vec3;

public class NbtUtils {
    @Nullable
    public static BlockPos readBlockPosFromArrayTag(CompoundTag tag, String tagName) {
        int[] pos;
        if (tag.m_128425_(tagName, 11) && (pos = tag.m_128465_("Pos")).length == 3) {
            return new BlockPos(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nullable
    public static Vec3 readVec3dFromListTag(@Nullable CompoundTag tag) {
        return NbtUtils.readVec3dFromListTag(tag, "Pos");
    }

    @Nullable
    public static Vec3 readVec3dFromListTag(@Nullable CompoundTag tag, String tagName) {
        ListTag tagList;
        if (tag != null && tag.m_128425_(tagName, 9) && (tagList = tag.m_128437_(tagName, 6)).m_7264_() == 6 && tagList.size() == 3) {
            return new Vec3(tagList.m_128772_(0), tagList.m_128772_(1), tagList.m_128772_(2));
        }
        return null;
    }

    @Nullable
    public static CompoundTag readNbtFromFile(File file) {
        FileInputStream is;
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        try {
            is = new FileInputStream(file);
        }
        catch (Exception e) {
            Litematica.logger.warn("Failed to read NBT data from file '{}' (failed to create the input stream)", (Object)file.getAbsolutePath());
            return null;
        }
        CompoundTag nbt = null;
        if (is != null) {
            try {
                nbt = NbtIo.m_128939_((InputStream)is);
            }
            catch (Exception e) {
                try {
                    is.close();
                    is = new FileInputStream(file);
                    nbt = NbtIo.m_128928_((DataInput)new DataInputStream(is));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (nbt == null) {
            Litematica.logger.warn("Failed to read NBT data from file '{}'", (Object)file.getAbsolutePath());
        }
        return nbt;
    }
}

