/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class MaterialCache {
    private static final MaterialCache INSTANCE = new MaterialCache();
    protected final IdentityHashMap<BlockState, ItemStack> buildItemsForStates = new IdentityHashMap();
    protected final IdentityHashMap<BlockState, ItemStack> displayItemsForStates = new IdentityHashMap();
    protected final WorldSchematic tempWorld = SchematicWorldHandler.createSchematicWorld(null);
    protected final BlockPos checkPos = new BlockPos(8, 0, 8);

    private MaterialCache() {
        WorldUtils.loadChunksSchematicWorld(this.tempWorld, this.checkPos, new Vec3i(1, 1, 1));
    }

    public static MaterialCache getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.buildItemsForStates.clear();
        this.displayItemsForStates.clear();
    }

    public ItemStack getRequiredBuildItemForState(BlockState state) {
        return this.getRequiredBuildItemForState(state, this.tempWorld, this.checkPos);
    }

    public ItemStack getRequiredBuildItemForState(BlockState state, Level world, BlockPos pos) {
        ItemStack stack = this.buildItemsForStates.get(state);
        if (stack == null) {
            stack = this.getItemForStateFromWorld(state, world, pos, true);
        }
        return stack;
    }

    public ItemStack getItemForDisplayNameForState(BlockState state) {
        ItemStack stack = this.displayItemsForStates.get(state);
        if (stack == null) {
            stack = this.getItemForStateFromWorld(state, this.tempWorld, this.checkPos, false);
        }
        return stack;
    }

    protected ItemStack getItemForStateFromWorld(BlockState state, Level world, BlockPos pos, boolean isBuildItem) {
        ItemStack stack;
        ItemStack itemStack = stack = isBuildItem ? this.getStateToItemOverride(state) : null;
        if (stack == null) {
            world.m_7731_(pos, state, 20);
            stack = state.m_60734_().m_7397_((BlockGetter)world, pos, state);
        }
        if (stack == null || stack.m_41619_()) {
            stack = ItemStack.f_41583_;
        } else {
            this.overrideStackSize(state, stack);
        }
        if (isBuildItem) {
            this.buildItemsForStates.put(state, stack);
        } else {
            this.displayItemsForStates.put(state, stack);
        }
        return stack;
    }

    public boolean requiresMultipleItems(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof FlowerPotBlock && block != Blocks.f_50276_;
    }

    public ImmutableList<ItemStack> getItems(BlockState state) {
        return this.getItems(state, this.tempWorld, this.checkPos);
    }

    public ImmutableList<ItemStack> getItems(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (block instanceof FlowerPotBlock && block != Blocks.f_50276_) {
            return ImmutableList.of((Object)new ItemStack((ItemLike)Blocks.f_50276_), (Object)block.m_7397_((BlockGetter)world, pos, state));
        }
        return ImmutableList.of((Object)this.getRequiredBuildItemForState(state, world, pos));
    }

    @Nullable
    protected ItemStack getStateToItemOverride(BlockState state) {
        Block block = state.m_60734_();
        if (block == Blocks.f_50040_ || block == Blocks.f_50110_ || block == Blocks.f_50142_ || block == Blocks.f_50257_ || block == Blocks.f_50446_) {
            return ItemStack.f_41583_;
        }
        if (block == Blocks.f_50093_) {
            return new ItemStack((ItemLike)Blocks.f_50493_);
        }
        if (block == Blocks.f_50180_) {
            return new ItemStack((ItemLike)Blocks.f_50180_);
        }
        if (block == Blocks.f_50181_) {
            return new ItemStack((ItemLike)Blocks.f_50181_);
        }
        if (block == Blocks.f_49991_) {
            if ((Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
                return new ItemStack((ItemLike)Items.f_42448_);
            }
            return ItemStack.f_41583_;
        }
        if (block == Blocks.f_49990_) {
            if ((Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
                return new ItemStack((ItemLike)Items.f_42447_);
            }
            return ItemStack.f_41583_;
        }
        if (block instanceof DoorBlock && state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
            return ItemStack.f_41583_;
        }
        if (block instanceof BedBlock && state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
            return ItemStack.f_41583_;
        }
        if (block instanceof DoublePlantBlock && state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
            return ItemStack.f_41583_;
        }
        return null;
    }

    protected void overrideStackSize(BlockState state, ItemStack stack) {
        Block block = state.m_60734_();
        if (block instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE) {
            stack.m_41764_(2);
        } else if (block == Blocks.f_50125_) {
            stack.m_41764_(((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_)).intValue());
        } else if (block instanceof TurtleEggBlock) {
            stack.m_41764_(((Integer)state.m_61143_((Property)TurtleEggBlock.f_57754_)).intValue());
        } else if (block instanceof SeaPickleBlock) {
            stack.m_41764_(((Integer)state.m_61143_((Property)SeaPickleBlock.f_56074_)).intValue());
        } else if (block instanceof CandleBlock) {
            stack.m_41764_(((Integer)state.m_61143_((Property)CandleBlock.f_152790_)).intValue());
        } else if (block instanceof MultifaceBlock) {
            stack.m_41764_(MultifaceBlock.m_221584_((BlockState)state).size());
        }
    }
}

