/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.util;

import net.minecraft.world.entity.player.Player;

public class EnchantmentUtils {
    public static boolean chargeExperience(Player player, int cost) {
        int playerExperience = EnchantmentUtils.getExperience(player);
        if (playerExperience >= cost) {
            player.m_6756_(-cost);
            if (EnchantmentUtils.getExperience(player) <= 0) {
                player.f_36080_ = 0.0f;
            }
            return true;
        }
        return false;
    }

    public static int getExperience(Player player) {
        int exp = EnchantmentUtils.getTotalExperienceForLevel(player.f_36078_);
        exp = (int)((float)exp + player.f_36080_ * (float)EnchantmentUtils.getTotalExperienceForLevel(player.f_36078_ + 1));
        return exp;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 30) {
            return 112 + (level - 31) * 9;
        }
        if (level > 15) {
            return 37 + (level - 16) * 5;
        }
        return 7 + (level - 1) * 2;
    }

    public static int getExperienceDifference(int start, int target) {
        if (target < start || start < 0) {
            throw new IllegalArgumentException("Invalid start/target");
        }
        if (target == start) {
            return 0;
        }
        int expReq = 0;
        for (int lvl = start + 1; lvl <= target; ++lvl) {
            expReq += EnchantmentUtils.getExperienceForLevel(lvl);
        }
        return expReq;
    }

    public static int getTotalExperienceForLevel(int level) {
        return EnchantmentUtils.getExperienceDifference(0, level);
    }

    public static int getLevelForExperience(int experience) {
        int level = 0;
        int xpToNextLevel;
        while (experience >= (xpToNextLevel = EnchantmentUtils.getExperienceForLevel(level + 1))) {
            ++level;
            experience -= xpToNextLevel;
        }
        return level;
    }
}

