/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.web.server.paths;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpExchange;
import com.teamresourceful.resourcefulconfig.common.config.Configurations;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.web.info.ResourcefulWebConfig;
import com.teamresourceful.resourcefulconfig.web.info.UserJwtPayload;
import com.teamresourceful.resourcefulconfig.web.server.paths.BasePath;
import com.teamresourceful.resourcefulconfig.web.utils.WebServerUtils;
import com.teamresourceful.resourcefulconfig.web.utils.WebVerifier;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record GetConfigsPath(WebVerifier verifier) implements BasePath
{
    @Override
    public void handleCall(HttpExchange exchange, UserJwtPayload payload) throws IOException {
        JsonArray array = new JsonArray();
        for (ResourcefulConfig config : Configurations.INSTANCE) {
            if (config.getWebConfig().hidden()) continue;
            array.add((JsonElement)GetConfigsPath.createConfigJson(config));
        }
        byte[] data = array.toString().getBytes();
        WebServerUtils.send(exchange, 200, "application/json", data);
    }

    @Override
    public String method() {
        return "GET";
    }

    private static JsonObject createConfigJson(ResourcefulConfig config) {
        ResourcefulWebConfig resourcefulWebConfig = config.getWebConfig();
        JsonObject json = new JsonObject();
        json.addProperty("id", config.getFileName());
        json.addProperty("title", resourcefulWebConfig.title());
        json.addProperty("description", resourcefulWebConfig.description());
        json.addProperty("icon", resourcefulWebConfig.icon());
        json.add("color", resourcefulWebConfig.toColor());
        json.add("links", (JsonElement)resourcefulWebConfig.toJsonLinks());
        return json;
    }
}

