/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiStringSmall;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialItemGui;
import se.mickelus.tetra.module.data.MaterialData;

@ParametersAreNonnullByDefault
public class HoloMaterialGroupGui
extends GuiElement {
    private final GuiElement materialsContainer;
    private final KeyframeAnimation labelAnimation;
    private final KeyframeAnimation[] itemAnimations;

    public HoloMaterialGroupGui(int x, int y, String category, List<MaterialData> materials, int offset, Consumer<MaterialData> onVariantHover, Consumer<MaterialData> onVariantBlur, Consumer<MaterialData> onVariantSelect) {
        super(x, y, 0, 50);
        GuiStringSmall label = new GuiStringSmall(0, 0, I18n.m_118938_((String)("tetra.variant_category." + category + ".label"), (Object[])new Object[0]));
        label.setColor(0x7F7F7F);
        this.addChild((GuiElement)label);
        this.materialsContainer = new GuiElement(0, 8, this.width, this.height);
        this.addChild(this.materialsContainer);
        this.labelAnimation = new KeyframeAnimation(100, (GuiElement)label).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX((float)(x - 5), (float)x)}).withDelay(40 * offset);
        int width = 0;
        this.itemAnimations = new KeyframeAnimation[materials.size()];
        for (int i = 0; i < materials.size(); ++i) {
            MaterialData material = materials.get(i);
            HoloMaterialItemGui item = new HoloMaterialItemGui(i / 2 * 20, i % 2 * 20, material, onVariantHover, onVariantBlur, onVariantSelect);
            this.materialsContainer.addChild((GuiElement)item);
            this.itemAnimations[i] = new KeyframeAnimation(80, (GuiElement)item).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY((float)(item.getY() - 5), (float)item.getY())}).withDelay(40 + 40 * (offset + i / 2));
            width = item.getX() + item.getWidth();
        }
        this.setWidth(Math.max(width, label.getWidth()));
    }

    public void updateSelection(MaterialData material) {
        this.materialsContainer.getChildren(HoloMaterialItemGui.class).forEach(variant -> variant.updateSelection(material));
    }

    public void animateIn() {
        this.labelAnimation.start();
        Arrays.stream(this.itemAnimations).forEach(KeyframeAnimation::start);
    }
}

