/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.getter;

import java.util.Arrays;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;

@ParametersAreNonnullByDefault
public class StatGetterAdd
implements IStatGetter {
    private final IStatGetter[] statGetters;
    private double offset = 0.0;

    public StatGetterAdd(IStatGetter ... statGetters) {
        this.statGetters = statGetters;
    }

    public StatGetterAdd(double offset, IStatGetter ... statGetters) {
        this(statGetters);
        this.offset = offset;
    }

    @Override
    public double getValue(Player player, ItemStack itemStack) {
        return Optional.of(Arrays.stream(this.statGetters).mapToDouble(getter -> getter.getValue(player, itemStack)).sum()).map(value -> value != 0.0 ? value + this.offset : value).get();
    }

    @Override
    public double getValue(Player player, ItemStack itemStack, String slot) {
        return Optional.of(Arrays.stream(this.statGetters).mapToDouble(getter -> getter.getValue(player, itemStack, slot)).sum()).map(value -> value != 0.0 ? value + this.offset : value).get();
    }

    @Override
    public double getValue(Player player, ItemStack itemStack, String slot, String improvement) {
        return Optional.of(Arrays.stream(this.statGetters).mapToDouble(getter -> getter.getValue(player, itemStack, slot, improvement)).sum()).map(value -> value != 0.0 ? value + this.offset : value).get();
    }
}

