/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.data;

import com.google.gson.JsonElement;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.bar.GuiStatIndicator;
import se.mickelus.tetra.gui.stats.data.StatIndicatorStore;
import se.mickelus.tetra.gui.stats.data.StatRegistry;
import se.mickelus.tetra.gui.stats.getter.ILabelGetter;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;

public class StandardStatBarDeserializer {
    public static GuiStatBase deserialize(JsonElement jsonElement) {
        StandardData data = (StandardData)StatRegistry.gson.fromJson(jsonElement, StandardData.class);
        return new GuiStatBar(0, 0, 59, data.key, data.min, data.max, data.segmented != null ? data.segmented : false, data.split != null ? data.split : false, data.inverted != null ? data.inverted : false, data.stat, data.label, data.tooltip, data.generateSorter != null ? data.generateSorter : false).setContexts(data.contexts != null ? data.contexts : new String[]{}).setIndicators(data.indicators != null ? StandardStatBarDeserializer.resolveIndicators(data.indicators) : new GuiStatIndicator[]{});
    }

    private static GuiStatIndicator[] resolveIndicators(ResourceLocation[] directories) {
        return (GuiStatIndicator[])Arrays.stream(directories).map(StatIndicatorStore.instance::getIndicatorsIn).flatMap(Arrays::stream).toArray(GuiStatIndicator[]::new);
    }

    record StandardData(String key, String[] contexts, double min, double max, Boolean segmented, Boolean split, Boolean inverted, IStatGetter stat, ILabelGetter label, ITooltipGetter tooltip, ResourceLocation[] indicators, Boolean generateSorter) {
    }
}

