/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.container.ChangeCompartmentPacket;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlockEntity;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerMenu;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerScreen;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;

@ParametersAreNonnullByDefault
public class ForgedContainerBlock
extends TetraWaterloggedBlock
implements IInteractiveBlock,
EntityBlock {
    public static final String identifier = "forged_container";
    public static final DirectionProperty facingProp = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty flippedProp = BooleanProperty.m_61465_((String)"flipped");
    public static final BooleanProperty locked1Prop = BooleanProperty.m_61465_((String)"locked1");
    public static final BooleanProperty locked2Prop = BooleanProperty.m_61465_((String)"locked2");
    public static final BooleanProperty anyLockedProp = BooleanProperty.m_61465_((String)"locked_any");
    public static final BooleanProperty openProp = BooleanProperty.m_61465_((String)"open");
    public static final BlockInteraction[] interactions = new BlockInteraction[]{new BlockInteraction(TetraToolActions.hammer, 3, Direction.SOUTH, 5.0f, 7.0f, 2.0f, 5.0f, new PropertyMatcher().where(locked1Prop, Predicates.equalTo((Object)true)).where(flippedProp, Predicates.equalTo((Object)false)), (world, pos, blockState, player, hand, hitFace) -> ForgedContainerBlock.breakLock(world, pos, player, 0, hand)), new BlockInteraction(TetraToolActions.hammer, 3, Direction.SOUTH, 11.0f, 13.0f, 2.0f, 5.0f, new PropertyMatcher().where(locked2Prop, Predicates.equalTo((Object)true)).where(flippedProp, Predicates.equalTo((Object)false)), (world, pos, blockState, player, hand, hitFace) -> ForgedContainerBlock.breakLock(world, pos, player, 1, hand)), new BlockInteraction(TetraToolActions.hammer, 3, Direction.SOUTH, 17.0f, 19.0f, 2.0f, 5.0f, new PropertyMatcher().where(locked1Prop, Predicates.equalTo((Object)true)).where(flippedProp, Predicates.equalTo((Object)true)), (world, pos, blockState, player, hand, hitFace) -> ForgedContainerBlock.breakLock(world, pos, player, 2, hand)), new BlockInteraction(TetraToolActions.hammer, 3, Direction.SOUTH, 23.0f, 25.0f, 2.0f, 5.0f, new PropertyMatcher().where(locked2Prop, Predicates.equalTo((Object)true)).where(flippedProp, Predicates.equalTo((Object)true)), (world, pos, blockState, player, hand, hitFace) -> ForgedContainerBlock.breakLock(world, pos, player, 3, hand)), new BlockInteraction(TetraToolActions.pry, 1, Direction.SOUTH, 1.0f, 15.0f, 3.0f, 4.0f, new PropertyMatcher().where(anyLockedProp, Predicates.equalTo((Object)false)).where(openProp, Predicates.equalTo((Object)false)).where(flippedProp, Predicates.equalTo((Object)false)), ForgedContainerBlock::open), new BlockInteraction(TetraToolActions.pry, 1, Direction.SOUTH, 15.0f, 28.0f, 3.0f, 4.0f, new PropertyMatcher().where(anyLockedProp, Predicates.equalTo((Object)false)).where(openProp, Predicates.equalTo((Object)false)).where(flippedProp, Predicates.equalTo((Object)true)), ForgedContainerBlock::open)};
    private static final VoxelShape shapeZ1 = ForgedContainerBlock.m_49796_((double)1.0, (double)0.0, (double)-15.0, (double)15.0, (double)12.0, (double)15.0);
    private static final VoxelShape shapeZ2 = ForgedContainerBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)31.0);
    private static final VoxelShape shapeX1 = ForgedContainerBlock.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    private static final VoxelShape shapeX2 = ForgedContainerBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)31.0, (double)12.0, (double)15.0);
    private static final VoxelShape shapeZ1Open = ForgedContainerBlock.m_49796_((double)1.0, (double)0.0, (double)-15.0, (double)15.0, (double)9.0, (double)15.0);
    private static final VoxelShape shapeZ2Open = ForgedContainerBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)9.0, (double)31.0);
    private static final VoxelShape shapeX1Open = ForgedContainerBlock.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0);
    private static final VoxelShape shapeX2Open = ForgedContainerBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)31.0, (double)9.0, (double)15.0);
    public static RegistryObject<ForgedContainerBlock> instance;

    public ForgedContainerBlock() {
        super(ForgedBlockCommon.propertiesSolid);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)facingProp, (Comparable)Direction.EAST)).m_61124_((Property)flippedProp, (Comparable)Boolean.valueOf(false))).m_61124_((Property)openProp, (Comparable)Boolean.valueOf(true))).m_61124_((Property)locked1Prop, (Comparable)Boolean.valueOf(false))).m_61124_((Property)locked2Prop, (Comparable)Boolean.valueOf(false))).m_61124_((Property)anyLockedProp, (Comparable)Boolean.valueOf(false)));
    }

    private static boolean breakLock(Level world, BlockPos pos, @Nullable Player player, int index, @Nullable InteractionHand hand) {
        ForgedContainerBlockEntity te = (ForgedContainerBlockEntity)world.m_7702_(pos);
        if (te != null) {
            te.getOrDelegate().breakLock(player, index, hand);
        }
        return true;
    }

    private static boolean open(Level world, BlockPos pos, BlockState blockState, Player player, InteractionHand hand, Direction facing) {
        ForgedContainerBlockEntity te = (ForgedContainerBlockEntity)world.m_7702_(pos);
        if (te != null) {
            te.getOrDelegate().open(player);
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        MenuScreens.m_96206_((MenuType)((MenuType)ForgedContainerMenu.type.get()), ForgedContainerScreen::new);
    }

    @Override
    public void commonInit(PacketHandler packetHandler) {
        packetHandler.registerPacket(ChangeCompartmentPacket.class, ChangeCompartmentPacket::new);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(Level world, BlockPos pos, BlockState state, Direction face, Collection<ToolAction> tools) {
        return (BlockInteraction[])Arrays.stream(interactions).filter(interaction -> interaction.isPotentialInteraction(world, pos, state, (Direction)state.m_61143_((Property)facingProp), face, tools)).toArray(BlockInteraction[]::new);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult didInteract = BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
        if (didInteract != InteractionResult.SUCCESS) {
            if (!world.f_46443_) {
                TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, ForgedContainerBlockEntity.class).ifPresent(te -> {
                    ForgedContainerBlockEntity delegate = te.getOrDelegate();
                    if (delegate.isOpen()) {
                        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)delegate, (BlockPos)delegate.m_58899_());
                    }
                });
            }
        } else {
            world.m_7260_(pos, state, state, 3);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.equals(newState.m_60734_())) {
            if (((Boolean)state.m_61143_((Property)openProp)).booleanValue() && !((Boolean)state.m_61143_((Property)flippedProp)).booleanValue()) {
                ForgedContainerBlock.dropBlockInventory(this, world, pos, newState);
            } else {
                TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, ForgedContainerBlockEntity.class).ifPresent(BlockEntity::m_7651_);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)facingProp);
        boolean flipped = (Boolean)state.m_61143_((Property)flippedProp);
        if (((Boolean)state.m_61143_((Property)openProp)).booleanValue()) {
            if (flipped) {
                switch (facing) {
                    case NORTH: {
                        return shapeX1Open;
                    }
                    case EAST: {
                        return shapeZ1Open;
                    }
                    case SOUTH: {
                        return shapeX2Open;
                    }
                    case WEST: {
                        return shapeZ2Open;
                    }
                }
            } else {
                switch (facing) {
                    case NORTH: {
                        return shapeX2Open;
                    }
                    case EAST: {
                        return shapeZ2Open;
                    }
                    case SOUTH: {
                        return shapeX1Open;
                    }
                    case WEST: {
                        return shapeZ1Open;
                    }
                }
            }
        } else if (flipped) {
            switch (facing) {
                case NORTH: {
                    return shapeX1;
                }
                case EAST: {
                    return shapeZ1;
                }
                case SOUTH: {
                    return shapeX2;
                }
                case WEST: {
                    return shapeZ2;
                }
            }
        } else {
            switch (facing) {
                case NORTH: {
                    return shapeX2;
                }
                case EAST: {
                    return shapeZ2;
                }
                case SOUTH: {
                    return shapeX1;
                }
                case WEST: {
                    return shapeZ1;
                }
            }
        }
        return null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{facingProp, flippedProp, locked1Prop, locked2Prop, anyLockedProp, openProp});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_8125_().m_122427_())).m_60629_(context)) {
            return (BlockState)super.m_5573_(context).m_61124_((Property)facingProp, (Comparable)context.m_8125_());
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction facing = (Direction)state.m_61143_((Property)facingProp);
        world.m_7731_(pos.m_121945_(facing.m_122427_()), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)flippedProp, (Comparable)Boolean.valueOf(true))).m_61124_((Property)facingProp, (Comparable)facing), 3);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        Direction pairedFacing = (Direction)state.m_61143_((Property)facingProp);
        pairedFacing = (Boolean)state.m_61143_((Property)flippedProp) != false ? pairedFacing.m_122428_() : pairedFacing.m_122427_();
        if (pairedFacing == facing && !this.equals(facingState.m_60734_())) {
            return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction facing = (Direction)state.m_61143_((Property)facingProp);
        if (Rotation.CLOCKWISE_180.equals((Object)rot) || Rotation.CLOCKWISE_90.equals((Object)rot) && (Direction.NORTH.equals((Object)facing) || Direction.SOUTH.equals((Object)facing)) || Rotation.COUNTERCLOCKWISE_90.equals((Object)rot) && (Direction.EAST.equals((Object)facing) || Direction.WEST.equals((Object)facing))) {
            state = (BlockState)state.m_61124_((Property)flippedProp, (Comparable)((Boolean)state.m_61143_((Property)flippedProp)));
        }
        return (BlockState)state.m_61124_((Property)facingProp, (Comparable)rot.m_55954_(facing));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)facingProp)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new ForgedContainerBlockEntity(p_153215_, p_153216_);
    }
}

