/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import com.google.gson.Gson;
import io.netty.buffer.Unpooled;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lol.bai.badpackets.api.C2SPacketReceiver;
import lol.bai.badpackets.api.PacketSender;
import lol.bai.badpackets.api.S2CPacketReceiver;
import lol.bai.badpackets.api.event.PacketSenderReadyCallback;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.DataReader;
import mcp.mobius.waila.access.DataWriter;
import mcp.mobius.waila.access.ServerAccessor;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.debug.DumpGenerator;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.plugin.PluginLoader;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.ExceptionUtil;
import mcp.mobius.waila.util.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Packets {
    private static final Log LOG = Log.create();
    public static final ResourceLocation VERSION = Waila.id("version");
    public static final ResourceLocation ENTITY = Waila.id("entity");
    public static final ResourceLocation BLOCK = Waila.id("block");
    public static final ResourceLocation CTX_RAW = Waila.id("ctx");
    public static final ResourceLocation CTX_TYPED = Waila.id("ctx_typed");
    public static final ResourceLocation CONFIG_SYNC_REQ = Waila.id("config_sync_req");
    public static final ResourceLocation DATA_RAW = Waila.id("data");
    public static final ResourceLocation DATA_TYPED = Waila.id("data_typed");
    public static final ResourceLocation PLUGIN = Waila.id("plugin");
    public static final ResourceLocation CONFIG = Waila.id("config");
    public static final ResourceLocation BLACKLIST = Waila.id("blacklist");
    public static final ResourceLocation GENERATE_CLIENT_DUMP = Waila.id("generate_client_dump");
    private static final Gson GSON = new Gson();

    public static void initServer() {
        PacketSenderReadyCallback.registerServer((handler, sender, server) -> {
            FriendlyByteBuf versionBuf = new FriendlyByteBuf(Unpooled.buffer());
            versionBuf.m_130130_(9);
            sender.send(VERSION, versionBuf);
            Packets.sendConfig(sender);
        });
        C2SPacketReceiver.register((ResourceLocation)VERSION, (server, player, handler, buf, responseSender) -> {
            int clientVersion = buf.m_130242_();
            if (clientVersion != 9) {
                handler.m_9942_((Component)Component.m_237113_((String)("WTHIT network version mismatch! Server version is 9 while client version is " + clientVersion)));
            }
        });
        C2SPacketReceiver.register((ResourceLocation)CONFIG_SYNC_REQ, (server, player, handler, buf, responseSender) -> server.execute(() -> Packets.sendConfig(responseSender)));
        C2SPacketReceiver.register((ResourceLocation)CTX_RAW, (server, player, handler, buf, responseSender) -> {
            CompoundTag ctx = buf.m_130260_();
            server.execute(() -> DataReader.SERVER.reset(ctx));
        });
        C2SPacketReceiver.register((ResourceLocation)CTX_TYPED, (server, player, handler, buf, responseSender) -> {
            IData ctx = DataReader.readTypedPacket(buf);
            server.execute(() -> DataReader.SERVER.add(ctx));
        });
        C2SPacketReceiver.register((ResourceLocation)ENTITY, (server, player, handler, buf, responseSender) -> {
            int entityId = buf.m_130242_();
            Vec3 hitPos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
            server.execute(() -> {
                Registrar registrar = Registrar.get();
                Level world = player.m_9236_();
                Entity entity = world.m_6815_(entityId);
                if (entity == null) {
                    return;
                }
                CompoundTag raw = DataWriter.SERVER.reset();
                IServerAccessor accessor = ServerAccessor.INSTANCE.set(world, player, (HitResult)new EntityHitResult(entity, hitPos), entity);
                for (IInstanceRegistry.Entry<IDataProvider<Entity>> provider : registrar.entityData.get(entity)) {
                    Packets.tryAppendData(provider.instance(), accessor);
                }
                raw.m_128405_("WailaEntityID", entity.m_19879_());
                raw.m_128356_("WailaTime", System.currentTimeMillis());
                DataWriter.SERVER.send(responseSender, (Player)player);
            });
        });
        C2SPacketReceiver.register((ResourceLocation)BLOCK, (server, player, handler, buf, responseSender) -> {
            BlockHitResult hitResult = buf.m_130283_();
            server.execute(() -> {
                BlockPos pos;
                Registrar registrar = Registrar.get();
                Level world = player.m_9236_();
                if (!world.m_46805_(pos = hitResult.m_82425_())) {
                    return;
                }
                BlockEntity blockEntity = world.m_7702_(pos);
                if (blockEntity == null) {
                    return;
                }
                BlockState state = world.m_8055_(pos);
                CompoundTag raw = DataWriter.SERVER.reset();
                IServerAccessor accessor = ServerAccessor.INSTANCE.set(world, player, (HitResult)hitResult, blockEntity);
                for (IInstanceRegistry.Entry<IDataProvider<BlockEntity>> provider : registrar.blockData.get(blockEntity)) {
                    Packets.tryAppendData(provider.instance(), accessor);
                }
                for (IInstanceRegistry.Entry<IDataProvider<BlockEntity>> provider : registrar.blockData.get(state.m_60734_())) {
                    Packets.tryAppendData(provider.instance(), accessor);
                }
                raw.m_128405_("x", pos.m_123341_());
                raw.m_128405_("y", pos.m_123342_());
                raw.m_128405_("z", pos.m_123343_());
                raw.m_128359_("id", BuiltInRegistries.f_257049_.m_7981_((Object)blockEntity.m_58903_()).toString());
                raw.m_128356_("WailaTime", System.currentTimeMillis());
                DataWriter.SERVER.send(responseSender, (Player)player);
            });
        });
    }

    public static void initClient() {
        PacketSenderReadyCallback.registerClient((handler, sender, client) -> {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130130_(9);
            sender.send(VERSION, buf);
        });
        S2CPacketReceiver.register((ResourceLocation)VERSION, (client, handler, buf, responseSender) -> {
            int serverVersion = buf.m_130242_();
            if (serverVersion != 9) {
                handler.m_104910_().m_129507_((Component)Component.m_237113_((String)("WTHIT network version mismatch! Server version is " + serverVersion + " while client version is 9")));
            }
        });
        S2CPacketReceiver.register((ResourceLocation)DATA_RAW, (client, handler, buf, responseSender) -> {
            CompoundTag data = buf.m_130260_();
            client.execute(() -> DataReader.CLIENT.reset(data));
        });
        S2CPacketReceiver.register((ResourceLocation)DATA_TYPED, (client, handler, buf, responseSender) -> {
            IData data = DataReader.readTypedPacket(buf);
            client.execute(() -> DataReader.CLIENT.add(data));
        });
        S2CPacketReceiver.register((ResourceLocation)PLUGIN, (client, handler, buf, responseSender) -> {
            List plugins = buf.m_236845_(FriendlyByteBuf::m_130281_);
            client.execute(() -> {
                PluginInfo.refresh();
                for (ResourceLocation plugin : plugins) {
                    ((PluginInfo)IPluginInfo.get(plugin)).setDisabledOnServer(true);
                }
                PluginLoader.INSTANCE.loadPlugins();
            });
        });
        S2CPacketReceiver.register((ResourceLocation)CONFIG, (client, handler, buf, responseSender) -> {
            HashMap<ResourceLocation, Object> map = new HashMap<ResourceLocation, Object>();
            int groupSize = buf.m_130242_();
            for (int i = 0; i < groupSize; ++i) {
                String namespace = buf.m_130277_();
                int groupLen = buf.m_130242_();
                block7: for (int j = 0; j < groupLen; ++j) {
                    ResourceLocation id = new ResourceLocation(namespace, buf.m_130277_());
                    byte type = buf.readByte();
                    switch (type) {
                        case 0: {
                            map.put(id, buf.readBoolean());
                            continue block7;
                        }
                        case 1: {
                            map.put(id, buf.m_130242_());
                            continue block7;
                        }
                        case 2: {
                            map.put(id, buf.readDouble());
                            continue block7;
                        }
                        case 3: {
                            map.put(id, buf.m_130277_());
                        }
                    }
                }
            }
            client.execute(() -> {
                for (ConfigEntry<Object> config : PluginConfig.getSyncableConfigs()) {
                    Object syncedValue;
                    ResourceLocation id = config.getId();
                    Object clientOnlyValue = config.getClientOnlyValue();
                    if (clientOnlyValue instanceof Enum) {
                        Enum e = (Enum)clientOnlyValue;
                        v0 = Enum.valueOf(e.getDeclaringClass(), map.getOrDefault(id, e.name()));
                    } else {
                        v0 = syncedValue = map.get(id);
                    }
                    if (syncedValue instanceof Double) {
                        Double d = (Double)syncedValue;
                        if (clientOnlyValue instanceof Integer) {
                            syncedValue = d.intValue();
                        }
                    }
                    config.setServerValue(syncedValue);
                }
                LOG.info("Received config from the server: {}", GSON.toJson((Object)map));
            });
        });
        S2CPacketReceiver.register((ResourceLocation)BLACKLIST, (client, handler, buf, responseSender) -> {
            Set blockRules = (Set)buf.m_236838_(HashSet::new, FriendlyByteBuf::m_130277_);
            Set blockEntityRules = (Set)buf.m_236838_(HashSet::new, FriendlyByteBuf::m_130277_);
            Set entityRules = (Set)buf.m_236838_(HashSet::new, FriendlyByteBuf::m_130277_);
            client.execute(() -> Waila.BLACKLIST_CONFIG.get().getView().sync(blockRules, blockEntityRules, entityRules));
        });
        S2CPacketReceiver.register((ResourceLocation)GENERATE_CLIENT_DUMP, (client, handler, buf, responseSender) -> client.execute(() -> {
            Path path = DumpGenerator.generate("client_dump");
            if (path != null && client.f_91074_ != null) {
                MutableComponent pathComponent = Component.m_237113_((String)path.toString()).m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path.toString())));
                client.f_91074_.m_5661_((Component)Component.m_237110_((String)"command.waila.client_dump_success", (Object[])new Object[]{pathComponent}), false);
            }
        }));
    }

    public static void sendConfig(PacketSender sender) {
        FriendlyByteBuf blacklistBuf = new FriendlyByteBuf(Unpooled.buffer());
        BlacklistConfig blacklist = Waila.BLACKLIST_CONFIG.get();
        blacklistBuf.m_236828_(blacklist.blocks, FriendlyByteBuf::m_130070_);
        blacklistBuf.m_236828_(blacklist.blockEntityTypes, FriendlyByteBuf::m_130070_);
        blacklistBuf.m_236828_(blacklist.entityTypes, FriendlyByteBuf::m_130070_);
        sender.send(BLACKLIST, blacklistBuf);
        FriendlyByteBuf configBuf = new FriendlyByteBuf(Unpooled.buffer());
        Map<String, List<ConfigEntry>> groups = PluginConfig.getSyncableConfigs().stream().collect(Collectors.groupingBy(c -> c.getId().m_135827_()));
        configBuf.m_130130_(groups.size());
        groups.forEach((namespace, entries) -> {
            configBuf.m_130070_(namespace);
            configBuf.m_130130_(entries.size());
            entries.forEach(e -> {
                configBuf.m_130070_(e.getId().m_135815_());
                Object v = e.getLocalValue();
                if (v instanceof Boolean) {
                    Boolean z = (Boolean)v;
                    configBuf.writeByte(0);
                    configBuf.writeBoolean(z.booleanValue());
                } else if (v instanceof Integer) {
                    Integer i = (Integer)v;
                    configBuf.writeByte(1);
                    configBuf.m_130130_(i.intValue());
                } else if (v instanceof Double) {
                    Double d = (Double)v;
                    configBuf.writeByte(2);
                    configBuf.writeDouble(d.doubleValue());
                } else if (v instanceof String) {
                    String str = (String)v;
                    configBuf.writeByte(3);
                    configBuf.m_130070_(str);
                } else if (v instanceof Enum) {
                    Enum en = (Enum)v;
                    configBuf.writeByte(3);
                    configBuf.m_130070_(en.name());
                }
            });
        });
        sender.send(CONFIG, configBuf);
    }

    private static <T> void tryAppendData(IDataProvider<T> provider, IServerAccessor<T> accessor) {
        block2: {
            try {
                provider.appendData(DataWriter.SERVER, accessor, PluginConfig.SERVER);
            }
            catch (Throwable t) {
                ServerPlayer player = accessor.getPlayer();
                if (!ExceptionUtil.dump(t, provider.getClass() + "\nplayer " + player.m_6302_(), null)) break block2;
                player.m_213846_((Component)Component.m_237113_((String)("Error on retrieving server data from provider " + provider.getClass().getName())));
            }
        }
    }
}

