/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.signal;

import com.simibubi.create.content.contraptions.ITransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.signal.SignalBlock;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class SignalBlockEntity
extends SmartBlockEntity
implements ITransformableBlockEntity {
    public TrackTargetingBehaviour<SignalBoundary> edgePoint;
    private SignalState state = SignalState.INVALID;
    private OverlayState overlay = OverlayState.SKIP;
    private int switchToRedAfterTrainEntered;
    private boolean lastReportedPower = false;

    public SignalBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        NBTHelper.writeEnum(tag, "State", this.state);
        NBTHelper.writeEnum(tag, "Overlay", this.overlay);
        tag.m_128379_("Power", this.lastReportedPower);
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.state = NBTHelper.readEnum(tag, "State", SignalState.class);
        this.overlay = NBTHelper.readEnum(tag, "Overlay", OverlayState.class);
        this.lastReportedPower = tag.m_128471_("Power");
        this.invalidateRenderBoundingBox();
    }

    @Nullable
    public SignalBoundary getSignal() {
        return this.edgePoint.getEdgePoint();
    }

    public boolean isPowered() {
        return this.state == SignalState.RED;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour<SignalBoundary>(this, EdgePointType.SIGNAL);
        behaviours.add(this.edgePoint);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        SignalBoundary boundary = this.getSignal();
        if (boundary == null) {
            this.enterState(SignalState.INVALID);
            this.setOverlay(OverlayState.RENDER);
            return;
        }
        BlockState blockState = this.m_58900_();
        blockState.m_61145_((Property)SignalBlock.POWERED).ifPresent(powered -> {
            if (this.lastReportedPower == powered) {
                return;
            }
            this.lastReportedPower = powered;
            boundary.updateBlockEntityPower(this);
            this.notifyUpdate();
        });
        blockState.m_61145_(SignalBlock.TYPE).ifPresent(stateType -> {
            SignalBlock.SignalType targetType = boundary.getTypeFor(this.f_58858_);
            if (stateType != targetType) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_(SignalBlock.TYPE, (Comparable)((Object)targetType)), 3);
                this.refreshBlockState();
            }
        });
        this.enterState(boundary.getStateFor(this.f_58858_));
        this.setOverlay(boundary.getOverlayFor(this.f_58858_));
    }

    public boolean getReportedPower() {
        return this.lastReportedPower;
    }

    public SignalState getState() {
        return this.state;
    }

    public OverlayState getOverlay() {
        return this.overlay;
    }

    public void setOverlay(OverlayState state) {
        if (this.overlay == state) {
            return;
        }
        this.overlay = state;
        this.notifyUpdate();
    }

    public void enterState(SignalState state) {
        if (this.switchToRedAfterTrainEntered > 0) {
            --this.switchToRedAfterTrainEntered;
        }
        if (this.state == state) {
            return;
        }
        if (state == SignalState.RED && this.switchToRedAfterTrainEntered > 0) {
            return;
        }
        this.state = state;
        this.switchToRedAfterTrainEntered = state == SignalState.GREEN || state == SignalState.YELLOW ? 15 : 0;
        this.notifyUpdate();
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_, this.edgePoint.getGlobalPosition()).m_82400_(2.0);
    }

    @Override
    public void transform(StructureTransform transform) {
        this.edgePoint.transform(transform);
    }

    public static enum SignalState {
        RED,
        YELLOW,
        GREEN,
        INVALID;


        public boolean isRedLight(float renderTime) {
            return this == RED || this == INVALID && renderTime % 40.0f < 3.0f;
        }

        public boolean isYellowLight(float renderTime) {
            return this == YELLOW;
        }

        public boolean isGreenLight(float renderTime) {
            return this == GREEN;
        }
    }

    public static enum OverlayState {
        RENDER,
        SKIP,
        DUAL;

    }
}

