/*
 * Decompiled with CFR 0.152.
 */
package net.olafski.fastleafdecay;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class FldScheduler {
    public static FldScheduler INSTANCE = new FldScheduler();
    List<BlockUpdate> plannedUpdates = new ArrayList<BlockUpdate>();
    List<BlockUpdate> scheduledUpdates = new ArrayList<BlockUpdate>();

    public void schedule(LevelAccessor levelAccessor, BlockPos pos, int delay) {
        this.plannedUpdates.add(new BlockUpdate(levelAccessor, pos, delay));
    }

    public void tick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            if (!this.plannedUpdates.isEmpty()) {
                this.scheduledUpdates.addAll(this.plannedUpdates);
                this.plannedUpdates.clear();
            }
            Iterator<BlockUpdate> iterator = this.scheduledUpdates.iterator();
            while (iterator.hasNext()) {
                BlockState state;
                BlockUpdate blockUpdate;
                BlockUpdate scheduledUpdate = blockUpdate = iterator.next();
                --blockUpdate.tick;
                if (scheduledUpdate.tick > 0) continue;
                iterator.remove();
                LevelAccessor levelAccessor = (LevelAccessor)scheduledUpdate.levelAccessorReference.get();
                if (levelAccessor == null || !levelAccessor.isAreaLoaded(scheduledUpdate.pos, 1) || !(state = levelAccessor.m_8055_(scheduledUpdate.pos)).m_204336_(BlockTags.f_13035_)) continue;
                state.m_222972_((ServerLevel)levelAccessor, scheduledUpdate.pos, levelAccessor.m_213780_());
            }
        }
    }

    class BlockUpdate {
        WeakReference<LevelAccessor> levelAccessorReference;
        BlockPos pos;
        int tick;

        public BlockUpdate(LevelAccessor levelAccessor, BlockPos pos, int tick) {
            this.levelAccessorReference = new WeakReference<LevelAccessor>(levelAccessor);
            this.pos = pos;
            this.tick = tick;
        }
    }
}

