/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.icetower;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.loot.TFLootTables;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.icetower.IceTowerBeardComponent;
import twilightforest.world.components.structures.icetower.IceTowerBossWingComponent;
import twilightforest.world.components.structures.icetower.IceTowerDecorator;
import twilightforest.world.components.structures.icetower.IceTowerMainComponent;
import twilightforest.world.components.structures.icetower.IceTowerRoofComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class IceTowerWingComponent
extends TowerWingComponent {
    protected static final int SIZE = 11;
    private static final int RANGE = 17;
    boolean hasBase = false;
    protected int treasureFloor = -1;

    public IceTowerWingComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        this((StructurePieceType)TFStructurePieceTypes.TFITWin.get(), nbt);
    }

    public IceTowerWingComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
        this.hasBase = nbt.m_128471_("hasBase");
        this.treasureFloor = nbt.m_128451_("treasureFloor");
    }

    protected IceTowerWingComponent(StructurePieceType piece, int i, int x, int y, int z, int pSize, int pHeight, Direction direction) {
        super(piece, i, x, y, z, pSize, pHeight, direction);
        if (this.deco == null) {
            this.deco = new IceTowerDecorator();
        }
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128379_("hasBase", this.hasBase);
        tagCompound.m_128405_("treasureFloor", this.treasureFloor);
    }

    @Override
    public void m_214092_(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        this.addOpening(0, 1, this.size / 2, Rotation.CLOCKWISE_180);
        this.hasBase = this.shouldHaveBase(rand);
        if (this.m_73548_() < 5) {
            Rotation dirOffset = RotationUtil.ROTATIONS[rand.m_188503_(RotationUtil.ROTATIONS.length)];
            for (Rotation rotation : RotationUtil.ROTATIONS) {
                Rotation dir = dirOffset.m_55952_(rotation);
                int[] dest = this.getValidOpening(rand, dir);
                if (this.m_73548_() == 4 && parent instanceof IceTowerMainComponent && !((IceTowerMainComponent)parent).hasBossWing) {
                    boolean hasBoss;
                    ((IceTowerMainComponent)parent).hasBossWing = hasBoss = this.makeBossTowerWing(list, rand, this.m_73548_() + 1, dest[0], dest[1], dest[2], 15, 41, dir);
                    continue;
                }
                int childHeight = (rand.m_188503_(2) + rand.m_188503_(2) + 2) * 10 + 1;
                this.makeTowerWing(list, rand, this.m_73548_() + 1, dest[0], dest[1], dest[2], 11, childHeight, dir);
            }
        }
        int floors = this.height / 10;
        if (this.treasureFloor == -1 && floors > 1) {
            this.treasureFloor = rand.m_188503_(floors - 1);
        }
        this.makeARoof(parent, list, rand);
        if (!this.hasBase) {
            this.makeABeard(parent, list, rand);
        }
    }

    protected boolean shouldHaveBase(RandomSource rand) {
        return this.m_73548_() == 0 || rand.m_188499_();
    }

    private boolean isOutOfRange(StructurePiece parent, int nx, int nz, int range) {
        BoundingBox sbb = parent.m_73547_();
        int centerX = sbb.m_162395_() + (sbb.m_162399_() - sbb.m_162395_() + 1) / 2;
        int centerZ = sbb.m_162398_() + (sbb.m_162401_() - sbb.m_162398_() + 1) / 2;
        return Math.abs(nx - centerX) > range || Math.abs(nz - centerZ) > range;
    }

    @Override
    public boolean makeTowerWing(StructurePieceAccessor list, RandomSource rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        IceTowerWingComponent wing;
        StructurePiece intersect;
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            if (!start.f_192778_.isEmpty() && this.isOutOfRange((StructurePiece)start.f_192778_.get(0), dx[0], dx[2], 17)) {
                return false;
            }
        }
        if ((intersect = list.m_141921_((wing = new IceTowerWingComponent((StructurePieceType)TFStructurePieceTypes.TFITWin.get(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction)).m_73547_())) == null || intersect == this) {
            list.m_142679_((StructurePiece)wing);
            if (list instanceof StructurePiecesBuilder) {
                StructurePiecesBuilder start = (StructurePiecesBuilder)list;
                wing.m_214092_((StructurePiece)start.f_192778_.get(0), list, rand);
            }
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    public boolean makeBossTowerWing(StructurePieceAccessor list, RandomSource rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        IceTowerBossWingComponent wing = new IceTowerBossWingComponent(index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        StructurePiece intersect = list.m_141921_(wing.m_73547_());
        if (intersect == null || intersect == this) {
            list.m_142679_((StructurePiece)wing);
            if (list instanceof StructurePiecesBuilder) {
                StructurePiecesBuilder start = (StructurePiecesBuilder)list;
                wing.m_214092_((StructurePiece)start.f_192778_.get(0), list, rand);
            }
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    @Override
    protected int getYByStairs(int rx, RandomSource rand, Rotation direction) {
        int floors = this.height / 10;
        return 11 + rand.m_188503_(floors - 1) * 10;
    }

    @Override
    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        RandomSource decoRNG = RandomSource.m_216335_((long)(world.m_7328_() + (long)this.f_73383_.m_162395_() * 321534781L ^ (long)this.f_73383_.m_162398_() * 756839L));
        this.m_226776_(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, false, rand, this.deco.randomBlocks);
        this.m_73535_(world, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        if (this.hasBase) {
            for (int x = 0; x < this.size; ++x) {
                for (int z = 0; z < this.size; ++z) {
                    this.m_73528_(world, this.deco.blockState, x, -1, z, sbb);
                }
            }
        }
        this.makeFloorsForTower(world, decoRNG, sbb);
        this.makeOpenings(world, sbb);
    }

    protected void makeFloorsForTower(WorldGenLevel world, RandomSource decoRNG, BoundingBox sbb) {
        int floors = this.height / 10;
        Rotation ladderDir = Rotation.COUNTERCLOCKWISE_90;
        Rotation downLadderDir = null;
        int floorHeight = 10;
        for (int i = 0; i < floors - 1; ++i) {
            this.placeFloor(world, decoRNG, sbb, floorHeight, i);
            downLadderDir = ladderDir.m_55952_(Rotation.CLOCKWISE_90);
            this.decorateFloor(world, decoRNG, i, i * floorHeight, i * floorHeight + floorHeight, ladderDir, downLadderDir, sbb);
        }
        int topFloor = floors - 1;
        this.decorateTopFloor(world, decoRNG, topFloor, topFloor * floorHeight, topFloor * floorHeight + floorHeight, ladderDir, downLadderDir, sbb);
    }

    protected void placeFloor(WorldGenLevel world, RandomSource rand, BoundingBox sbb, int floorHeight, int floor) {
        for (int x = 1; x < this.size - 1; ++x) {
            for (int z = 1; z < this.size - 1; ++z) {
                this.m_73434_(world, this.deco.floorState, x, floor * floorHeight + floorHeight, z, sbb);
            }
        }
    }

    @Override
    protected void makeDoorOpening(WorldGenLevel world, int dx, int dy, int dz, BoundingBox sbb) {
        super.makeDoorOpening(world, dx, dy, dz, sbb);
        if (this.m_73398_((BlockGetter)world, dx, dy + 2, dz, sbb).m_60734_() != Blocks.f_50016_) {
            this.m_73434_(world, this.deco.accentState, dx, dy + 2, dz, sbb);
        }
    }

    @Override
    protected void decorateFloor(WorldGenLevel world, RandomSource rand, int floor, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, BoundingBox sbb) {
        boolean hasTreasure = this.treasureFloor == floor;
        switch (rand.m_188503_(8)) {
            case 0: {
                if (this.isNoDoorAreaRotated(9, bottom + 5, 1, 10, top + 1, 7, ladderUpDir)) {
                    this.decorateWraparoundWallSteps(world, bottom, top, ladderUpDir, hasTreasure, sbb);
                    break;
                }
            }
            case 1: {
                if (this.isNoDoorAreaRotated(7, bottom, 0, 10, top + 1, 10, ladderUpDir)) {
                    this.decorateFarWallSteps(world, bottom, top, ladderUpDir, hasTreasure, sbb);
                    break;
                }
            }
            case 2: {
                if (this.isNoDoorAreaRotated(9, bottom + 5, 1, 10, top + 1, 7, ladderUpDir)) {
                    this.decorateWraparoundWallStepsPillars(world, bottom, top, ladderUpDir, ladderDownDir, hasTreasure, sbb);
                    break;
                }
            }
            case 3: {
                this.decoratePlatform(world, rand, bottom, top, ladderUpDir, ladderDownDir, hasTreasure, sbb);
                break;
            }
            case 4: {
                this.decoratePillarParkour(world, rand, bottom, top, ladderUpDir, ladderDownDir, hasTreasure, sbb);
                break;
            }
            case 5: {
                this.decoratePillarPlatforms(world, bottom, top, ladderUpDir, hasTreasure, sbb);
                break;
            }
            case 6: {
                this.decoratePillarPlatformsOutside(world, bottom, top, ladderUpDir, hasTreasure, sbb);
                break;
            }
            default: {
                this.decorateQuadPillarStairs(world, rand, bottom, top, ladderUpDir, ladderDownDir, hasTreasure, sbb);
            }
        }
    }

    private boolean isNoDoorAreaRotated(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Rotation rotation) {
        boolean isClear = true;
        BoundingBox exclusionBox = switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new BoundingBox(this.size - 1 - maxZ, minY, minX, this.size - 1 - minZ, maxY, maxX);
            case Rotation.CLOCKWISE_180 -> new BoundingBox(this.size - 1 - maxX, minY, this.size - 1 - maxZ, this.size - 1 - minX, maxY, this.size - 1 - minZ);
            case Rotation.COUNTERCLOCKWISE_90 -> new BoundingBox(minZ, minY, this.size - 1 - maxX, maxZ, maxY, this.size - 1 - minX);
            default -> new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        };
        for (BlockPos door : this.openings) {
            if (!exclusionBox.m_71051_((Vec3i)door)) continue;
            isClear = false;
        }
        return isClear;
    }

    protected void decorateTopFloor(WorldGenLevel world, RandomSource rand, int floor, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, BoundingBox sbb) {
        if (rand.m_188499_()) {
            this.decoratePillarsCorners(world, rand, bottom, top, ladderDownDir, sbb);
        } else {
            this.decoratePillarsGrid(world, rand, bottom, top, ladderDownDir, sbb);
        }
        if (this.isDeadEnd()) {
            this.decorateTopFloorTreasure(world, bottom, ladderDownDir, sbb);
        }
    }

    private void decorateTopFloorTreasure(WorldGenLevel world, int bottom, Rotation rotation, BoundingBox sbb) {
        this.fillBlocksRotated(world, sbb, 5, bottom + 1, 5, 5, bottom + 4, 5, this.deco.pillarState, rotation);
        this.placeTreasureAtCurrentPosition(world, 5, bottom + 5, 5, TFLootTables.AURORA_ROOM, sbb);
    }

    private void decoratePillars(WorldGenLevel world, int bottom, int top, Rotation rotation, BoundingBox sbb) {
        this.fillBlocksRotated(world, sbb, 3, bottom + 1, 3, 3, top - 1, 3, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 1, 3, 7, top - 1, 3, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 3, bottom + 1, 7, 3, top - 1, 7, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 1, 7, 7, top - 1, 7, this.deco.pillarState, rotation);
    }

    private void decoratePillarsGrid(WorldGenLevel world, RandomSource rand, int bottom, int top, Rotation rotation, BoundingBox sbb) {
        BlockState pillarEW = (BlockState)this.deco.pillarState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
        BlockState pillarNS = (BlockState)this.deco.pillarState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 1, 3, bottom + 5, 9, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 5, 1, 7, bottom + 5, 9, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 3, 9, bottom + 5, 3, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 7, 9, bottom + 5, 7, pillarNS, rotation);
        this.decoratePillars(world, bottom, top, rotation, sbb);
    }

    private void decoratePillarsCorners(WorldGenLevel world, RandomSource rand, int bottom, int top, Rotation rotation, BoundingBox sbb) {
        BlockState pillarEW = (BlockState)this.deco.pillarState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
        BlockState pillarNS = (BlockState)this.deco.pillarState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 1, 3, bottom + 5, 9, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 5, 1, 7, bottom + 5, 9, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 3, 9, bottom + 5, 3, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 7, 9, bottom + 5, 7, pillarNS, rotation);
        this.fillAirRotated(world, sbb, 3, bottom + 5, 3, 7, bottom + 5, 7, rotation);
        this.decoratePillars(world, bottom, top, rotation, sbb);
    }

    private void decorateFarWallSteps(WorldGenLevel world, int bottom, int top, Rotation ladderUpDir, boolean hasTreasure, BoundingBox sbb) {
        int by;
        int y;
        int z;
        for (z = 1; z < 10; ++z) {
            y = bottom + 10 - z / 2;
            this.setBlockStateRotated(world, z % 2 == 0 ? this.deco.pillarState : this.deco.platformState, 9, y, z, ladderUpDir, sbb);
            for (by = bottom + 1; by < y; ++by) {
                this.setBlockStateRotated(world, this.deco.pillarState, 9, by, z, ladderUpDir, sbb);
            }
        }
        for (z = 1; z < 10; ++z) {
            y = bottom + 1 + z / 2;
            this.setBlockStateRotated(world, z % 2 == 0 ? this.deco.platformState : this.deco.pillarState, 8, y, z, ladderUpDir, sbb);
            for (by = bottom + 1; by < y; ++by) {
                this.setBlockStateRotated(world, this.deco.pillarState, 8, by, z, ladderUpDir, sbb);
            }
        }
        this.setBlockStateRotated(world, this.deco.platformState, 7, bottom + 1, 1, ladderUpDir, sbb);
        for (z = 2; z < 7; ++z) {
            this.setBlockStateRotated(world, AIR, 9, top, z, ladderUpDir, sbb);
        }
        BlockState pillarNS = (BlockState)this.deco.pillarState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
        if (hasTreasure) {
            this.placeTreasureRotated(world, 1, bottom + 8, 5, this.m_73549_().m_122424_(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
            this.setBlockStateRotated(world, pillarNS, 1, bottom + 7, 5, ladderUpDir, sbb);
        }
    }

    private void decorateWraparoundWallSteps(WorldGenLevel world, int bottom, int top, Rotation ladderUpDir, boolean hasTreasure, BoundingBox sbb) {
        int y;
        int z;
        BlockState topPlatform = (BlockState)this.deco.platformState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP);
        BlockState bottomPlatform = (BlockState)this.deco.platformState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM);
        for (z = 1; z < 10; ++z) {
            y = bottom + 10 - z / 2;
            this.setBlockStateRotated(world, z % 2 == 0 ? topPlatform : bottomPlatform, 9, y, z, ladderUpDir, sbb);
        }
        for (int x = 1; x < 9; ++x) {
            y = bottom + 2 + (x - 1) / 2;
            this.setBlockStateRotated(world, x % 2 == 0 ? topPlatform : bottomPlatform, x, y, 9, ladderUpDir, sbb);
        }
        this.setBlockStateRotated(world, topPlatform, 1, bottom + 1, 8, ladderUpDir, sbb);
        this.setBlockStateRotated(world, this.deco.platformState, 1, bottom + 1, 7, ladderUpDir, sbb);
        for (z = 2; z < 7; ++z) {
            this.setBlockStateRotated(world, AIR, 9, top, z, ladderUpDir, sbb);
        }
        if (hasTreasure) {
            this.placeTreasureRotated(world, 1, bottom + 5, 5, this.m_73549_(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
            BlockState pillarNS = (BlockState)this.deco.pillarState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
            this.setBlockStateRotated(world, pillarNS, 1, bottom + 4, 5, ladderUpDir, sbb);
        }
    }

    private void decorateWraparoundWallStepsPillars(WorldGenLevel world, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, boolean hasTreasure, BoundingBox sbb) {
        Rotation rotation = ladderDownDir;
        BlockState pillarEW = (BlockState)this.deco.pillarState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
        BlockState pillarNS = (BlockState)this.deco.pillarState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
        this.decorateWraparoundWallSteps(world, bottom, top, ladderUpDir, false, sbb);
        this.decoratePillars(world, bottom, top, rotation, sbb);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 1, 3, bottom + 5, 2, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 5, 1, 7, bottom + 5, 2, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 8, bottom + 5, 3, 9, bottom + 5, 3, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 8, bottom + 5, 7, 9, bottom + 5, 7, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 2, 3, 2, bottom + 2, 3, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 6, 3, 2, bottom + 6, 3, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 4, 7, 2, bottom + 4, 7, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 8, 7, 2, bottom + 8, 7, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 3, bottom + 6, 8, 3, bottom + 6, 9, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 8, 8, 7, bottom + 8, 9, pillarEW, rotation);
        if (hasTreasure) {
            this.placeTreasureRotated(world, 7, bottom + 6, 1, this.m_73549_(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
        }
    }

    private void decoratePlatform(WorldGenLevel world, RandomSource rand, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, boolean hasTreasure, BoundingBox sbb) {
        int x;
        int y;
        int z;
        BlockState topPlatform = (BlockState)this.deco.platformState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP);
        BlockState bottomPlatform = (BlockState)this.deco.platformState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM);
        this.decoratePillars(world, bottom, top, ladderDownDir, sbb);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 3, 7, bottom + 5, 7, this.deco.floorState, ladderDownDir);
        for (z = 6; z < 10; ++z) {
            y = bottom - 2 + z / 2;
            this.setBlockStateRotated(world, z % 2 == 1 ? topPlatform : bottomPlatform, 1, y, z, ladderDownDir, sbb);
        }
        for (x = 2; x < 6; ++x) {
            y = bottom + 2 + x / 2;
            this.setBlockStateRotated(world, x % 2 == 1 ? topPlatform : bottomPlatform, x, y, 9, ladderDownDir, sbb);
        }
        this.setBlockStateRotated(world, this.deco.platformState, 5, bottom + 5, 8, ladderDownDir, sbb);
        this.setBlockStateRotated(world, this.deco.platformState, 5, bottom + 6, 2, ladderUpDir, sbb);
        for (x = 5; x < 10; ++x) {
            y = bottom + 4 + x / 2;
            this.setBlockStateRotated(world, x % 2 == 1 ? topPlatform : bottomPlatform, x, y, 1, ladderUpDir, sbb);
            if (x <= 6) continue;
            this.setBlockStateRotated(world, AIR, x, top, 1, ladderUpDir, sbb);
        }
        for (z = 2; z < 5; ++z) {
            y = bottom + 8 + z / 2;
            this.setBlockStateRotated(world, AIR, 9, top, z, ladderUpDir, sbb);
            this.setBlockStateRotated(world, z % 2 == 1 ? topPlatform : bottomPlatform, 9, y, z, ladderUpDir, sbb);
        }
        if (hasTreasure) {
            this.placeTreasureRotated(world, 3, bottom + 6, 5, this.m_73549_(), ladderDownDir, TFLootTables.AURORA_CACHE, false, sbb);
        }
    }

    private void decorateQuadPillarStairs(WorldGenLevel world, RandomSource rand, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, boolean hasTreasure, BoundingBox sbb) {
        int x;
        int y;
        int z;
        this.decoratePillars(world, bottom, top, ladderDownDir, sbb);
        BlockState topPlatform = (BlockState)this.deco.platformState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP);
        BlockState bottomPlatform = (BlockState)this.deco.platformState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM);
        for (z = 6; z < 9; ++z) {
            y = bottom - 2 + z / 2;
            this.setBlockStateRotated(world, z % 2 == 1 ? topPlatform : bottomPlatform, 2, y, z, ladderDownDir, sbb);
        }
        for (x = 3; x < 9; ++x) {
            y = bottom + 1 + x / 2;
            this.setBlockStateRotated(world, x % 2 == 1 ? topPlatform : bottomPlatform, x, y, 8, ladderDownDir, sbb);
        }
        for (z = 7; z > 1; --z) {
            y = top - 2 - (z - 1) / 2;
            if (z < 4) {
                this.setBlockStateRotated(world, AIR, 8, top, z, ladderDownDir, sbb);
            }
            this.setBlockStateRotated(world, z % 2 == 1 ? topPlatform : bottomPlatform, 8, y, z, ladderDownDir, sbb);
        }
        for (x = 7; x > 3; --x) {
            y = top + 1 - (x - 1) / 2;
            this.setBlockStateRotated(world, AIR, x, top, 2, ladderDownDir, sbb);
            this.setBlockStateRotated(world, x % 2 == 1 ? topPlatform : bottomPlatform, x, y, 2, ladderDownDir, sbb);
        }
        if (hasTreasure) {
            this.placeTreasureRotated(world, 3, bottom + 7, 7, this.m_73549_(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
        }
    }

    private void decoratePillarPlatforms(WorldGenLevel world, int bottom, int top, Rotation ladderUpDir, boolean hasTreasure, BoundingBox sbb) {
        Rotation r = ladderUpDir;
        for (int i = 1; i < 10; ++i) {
            r = r.m_55952_(Rotation.CLOCKWISE_90);
            this.fillBlocksRotated(world, sbb, 2, bottom + i, 2, 4, bottom + i, 4, this.deco.floorState, this.f_73379_);
        }
        this.fillAirRotated(world, sbb, 2, top, 2, 8, top, 4, ladderUpDir);
        this.fillAirRotated(world, sbb, 2, top, 2, 4, top, 6, ladderUpDir);
        this.setBlockStateRotated(world, this.deco.platformState, 7, top, 3, ladderUpDir, sbb);
        this.setBlockStateRotated(world, this.deco.platformState, 3, top, 3, ladderUpDir, sbb);
        this.decoratePillars(world, bottom, top, ladderUpDir, sbb);
        if (hasTreasure) {
            this.placeTreasureRotated(world, 3, bottom + 5, 2, this.m_73549_(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
        }
    }

    private void decoratePillarPlatformsOutside(WorldGenLevel world, int bottom, int top, Rotation ladderUpDir, boolean hasTreasure, BoundingBox sbb) {
        for (int i = 0; i < 2; ++i) {
            for (Rotation r : RotationUtil.ROTATIONS) {
                if (i == 0 && r == Rotation.NONE) continue;
                Rotation rotation = ladderUpDir.m_55952_(r);
                this.fillBlocksRotated(world, sbb, 1, bottom + i, 1, 3, bottom + i, 3, this.deco.platformState, rotation);
                this.fillBlocksRotated(world, sbb, 4, bottom + i, 1, 6, bottom + i, 3, this.deco.floorState, rotation);
            }
        }
        Rotation rotation = ladderUpDir.m_55952_(Rotation.CLOCKWISE_180);
        this.fillAirRotated(world, sbb, 5, top, 8, 9, top, 9, rotation);
        this.fillAirRotated(world, sbb, 8, top, 6, 9, top, 9, rotation);
        this.fillBlocksRotated(world, sbb, 8, top - 2, 7, 9, top - 2, 7, this.deco.platformState, rotation);
        this.fillBlocksRotated(world, sbb, 8, top - 2, 8, 9, top - 2, 9, this.deco.floorState, rotation);
        this.fillBlocksRotated(world, sbb, 7, top - 1, 8, 7, top - 1, 9, this.deco.platformState, rotation);
        this.fillBlocksRotated(world, sbb, 6, top - 1, 8, 6, top - 1, 9, (BlockState)this.deco.platformState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP), rotation);
        this.fillBlocksRotated(world, sbb, 5, top, 8, 5, top, 9, this.deco.platformState, rotation);
        this.decoratePillars(world, bottom, top, ladderUpDir, sbb);
        if (hasTreasure) {
            this.placeTreasureRotated(world, 3, bottom + 5, 2, this.m_73549_(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
        }
    }

    private void decoratePillarParkour(WorldGenLevel world, RandomSource rand, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, boolean hasTreasure, BoundingBox sbb) {
        Rotation rotation = ladderDownDir;
        BlockState pillarEW = (BlockState)this.deco.pillarState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
        BlockState pillarNS = (BlockState)this.deco.pillarState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
        this.decoratePillars(world, bottom, top, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.pillarState, 5, bottom + 1, 5, rotation, sbb);
        this.fillBlocksRotated(world, sbb, 5, bottom + 2, 7, 5, bottom + 2, 9, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 3, 7, 2, bottom + 3, 7, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 3, bottom + 3, 8, 3, bottom + 3, 9, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 7, 7, 2, bottom + 7, 7, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 3, bottom + 7, 8, 3, bottom + 7, 9, pillarEW, rotation);
        this.fillAirRotated(world, sbb, 3, bottom + 4, 7, 3, bottom + 6, 7, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 4, 5, 2, bottom + 4, 5, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 1, 3, bottom + 5, 2, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 3, 2, bottom + 5, 3, pillarNS, rotation);
        this.fillAirRotated(world, sbb, 3, bottom + 6, 3, 3, bottom + 8, 3, rotation);
        this.fillBlocksRotated(world, sbb, 5, bottom + 6, 1, 5, bottom + 6, 2, pillarEW, rotation);
        this.fillAirRotated(world, sbb, 7, bottom + 8, 3, 7, bottom + 10, 3, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 7, 1, 7, bottom + 7, 2, pillarEW, rotation);
        this.fillBlocksRotated(world, sbb, 8, bottom + 7, 3, 9, bottom + 7, 3, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 8, bottom + 8, 5, 9, bottom + 8, 5, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 8, bottom + 9, 7, 9, bottom + 9, 7, pillarNS, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 9, 8, 7, bottom + 9, 9, pillarEW, rotation);
        this.fillAirRotated(world, sbb, 2, top, 2, 8, top, 4, ladderUpDir);
        this.fillAirRotated(world, sbb, 2, top, 2, 4, top, 6, ladderUpDir);
        if (hasTreasure) {
            this.placeTreasureRotated(world, 8, bottom + 8, 7, this.m_73549_(), ladderUpDir, TFLootTables.AURORA_CACHE, false, sbb);
        }
    }

    @Override
    public void makeARoof(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        int index = this.m_73548_();
        this.tryToFitRoof(list, rand, new IceTowerRoofComponent(index + 1, this, this.m_142171_().m_123341_(), this.m_142171_().m_123342_(), this.m_142171_().m_123343_()));
    }

    @Override
    public void makeABeard(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        int index = this.m_73548_();
        IceTowerBeardComponent beard = new IceTowerBeardComponent(index + 1, this, this.m_142171_().m_123341_(), this.m_142171_().m_123342_(), this.m_142171_().m_123343_());
        list.m_142679_((StructurePiece)beard);
        beard.m_214092_(this, list, rand);
    }
}

