/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import org.jetbrains.annotations.NotNull;
import twilightforest.data.tags.CustomTagGenerator;
import twilightforest.init.custom.WoodPalettes;
import twilightforest.util.WoodPalette;
import twilightforest.world.components.processors.StateTransfiguringProcessor;
import twilightforest.world.components.processors.WoodPaletteSwizzle;

public record SwizzleConfig(HolderSet<WoodPalette> targets, WeightedRandomList<WeightedEntry.Wrapper<HolderSet<WoodPalette>>> paletteChoices, List<ProcessorRule> preprocessingRules) implements FeatureConfiguration
{
    public static final Codec<SwizzleConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.m_206277_(WoodPalettes.WOOD_PALETTE_TYPE_KEY).fieldOf("target_palettes").forGetter(SwizzleConfig::targets), (App)WeightedRandomList.m_146333_((Codec)WeightedEntry.Wrapper.m_146305_((Codec)RegistryCodecs.m_206277_(WoodPalettes.WOOD_PALETTE_TYPE_KEY))).fieldOf("palette_choices").forGetter(SwizzleConfig::paletteChoices), (App)ProcessorRule.f_74215_.listOf().fieldOf("preprocessing_rules").orElseGet(Collections::emptyList).forGetter(SwizzleConfig::preprocessingRules)).apply((Applicative)instance, SwizzleConfig::new));

    @NotNull
    public static WeightedRandomList<WeightedEntry.Wrapper<HolderSet<WoodPalette>>> buildRarityPalette(HolderGetter<WoodPalette> paletteHolders) {
        WeightedEntry.Wrapper common = WeightedEntry.m_146290_((Object)((HolderSet)paletteHolders.m_254901_(CustomTagGenerator.WoodPaletteTagGenerator.COMMON_PALETTES).get()), (int)8);
        WeightedEntry.Wrapper uncommon = WeightedEntry.m_146290_((Object)((HolderSet)paletteHolders.m_254901_(CustomTagGenerator.WoodPaletteTagGenerator.UNCOMMON_PALETTES).get()), (int)4);
        WeightedEntry.Wrapper rare = WeightedEntry.m_146290_((Object)((HolderSet)paletteHolders.m_254901_(CustomTagGenerator.WoodPaletteTagGenerator.RARE_PALETTES).get()), (int)3);
        WeightedEntry.Wrapper treasure = WeightedEntry.m_146290_((Object)((HolderSet)paletteHolders.m_254901_(CustomTagGenerator.WoodPaletteTagGenerator.TREASURE_PALETTES).get()), (int)1);
        return WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{common, uncommon, rare, treasure});
    }

    public static SwizzleConfig generate(HolderGetter<WoodPalette> paletteHolders, TagKey<WoodPalette> swizzleMask, WeightedRandomList<WeightedEntry.Wrapper<HolderSet<WoodPalette>>> paletteChoices, ProcessorRule ... postProcessingRules) {
        return new SwizzleConfig((HolderSet<WoodPalette>)paletteHolders.m_254956_(swizzleMask), paletteChoices, List.of(postProcessingRules));
    }

    public void buildAddProcessors(StructurePlaceSettings settings, RandomSource random) {
        if (!this.preprocessingRules().isEmpty()) {
            settings.m_74383_((StructureProcessor)new StateTransfiguringProcessor(this.preprocessingRules()));
        }
        for (Holder targetPalette : this.targets) {
            settings.m_74383_((StructureProcessor)new WoodPaletteSwizzle((Holder<WoodPalette>)targetPalette, (Holder<WoodPalette>)((Holder)((HolderSet)((WeightedEntry.Wrapper)this.paletteChoices().m_216829_(random).get()).m_146310_()).m_213653_(random).get())));
        }
    }
}

