/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class EntityUtils {
    public static final Predicate<Entity> NOT_PLAYER = entity -> !(entity instanceof Player);

    public static boolean isCreativeMode(Player player) {
        return player.m_150110_().f_35937_;
    }

    public static boolean hasToolItem(LivingEntity entity) {
        return EntityUtils.hasToolItemInHand(entity, InteractionHand.MAIN_HAND) || EntityUtils.hasToolItemInHand(entity, InteractionHand.OFF_HAND);
    }

    public static boolean hasToolItemInHand(LivingEntity entity, InteractionHand hand) {
        ItemStack toolItem = DataManager.getToolItem();
        if (toolItem.m_41619_()) {
            return entity.m_21205_().m_41619_();
        }
        ItemStack stackHand = entity.m_21120_(hand);
        if (ItemStack.m_41656_((ItemStack)toolItem, (ItemStack)stackHand)) {
            return !toolItem.m_41782_() || ItemUtils.areTagsEqualIgnoreDamage(toolItem, stackHand);
        }
        return false;
    }

    @Nullable
    public static InteractionHand getUsedHandForItem(Player player, ItemStack stack) {
        InteractionHand hand = null;
        if (ItemStack.m_41656_((ItemStack)player.m_21205_(), (ItemStack)stack)) {
            hand = InteractionHand.MAIN_HAND;
        } else if (player.m_21205_().m_41619_() && ItemStack.m_41656_((ItemStack)player.m_21206_(), (ItemStack)stack)) {
            hand = InteractionHand.OFF_HAND;
        }
        return hand;
    }

    public static boolean areStacksEqualIgnoreDurability(ItemStack stack1, ItemStack stack2) {
        return ItemStack.m_41656_((ItemStack)stack1, (ItemStack)stack2) && ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static Direction getHorizontalLookingDirection(Entity entity) {
        return Direction.m_122364_((double)entity.m_146908_());
    }

    public static Direction getVerticalLookingDirection(Entity entity) {
        return entity.m_146909_() > 0.0f ? Direction.DOWN : Direction.UP;
    }

    public static Direction getClosestLookingDirection(Entity entity) {
        if (entity.m_146909_() > 60.0f) {
            return Direction.DOWN;
        }
        if (-entity.m_146909_() > 60.0f) {
            return Direction.UP;
        }
        return EntityUtils.getHorizontalLookingDirection(entity);
    }

    @Nullable
    public static <T extends Entity> T findEntityByUUID(List<T> list, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Entity entity : list) {
            if (!entity.m_20148_().equals(uuid)) continue;
            return (T)entity;
        }
        return null;
    }

    @Nullable
    public static String getEntityId(Entity entity) {
        EntityType entitytype = entity.m_6095_();
        ResourceLocation resourcelocation = EntityType.m_20613_((EntityType)entitytype);
        return entitytype.m_20584_() && resourcelocation != null ? resourcelocation.toString() : null;
    }

    @Nullable
    private static Entity createEntityFromNBTSingle(CompoundTag nbt, Level world) {
        try {
            Optional optional = EntityType.m_20642_((CompoundTag)nbt, (Level)world);
            if (optional.isPresent()) {
                Entity entity = (Entity)optional.get();
                entity.m_20084_(UUID.randomUUID());
                return entity;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static Entity createEntityAndPassengersFromNBT(CompoundTag nbt, Level world) {
        Entity entity = EntityUtils.createEntityFromNBTSingle(nbt, world);
        if (entity == null) {
            return null;
        }
        if (nbt.m_128425_("Passengers", 9)) {
            ListTag taglist = nbt.m_128437_("Passengers", 10);
            for (int i = 0; i < taglist.size(); ++i) {
                Entity passenger = EntityUtils.createEntityAndPassengersFromNBT(taglist.m_128728_(i), world);
                if (passenger == null) continue;
                passenger.m_7998_(entity, true);
            }
        }
        return entity;
    }

    public static void spawnEntityAndPassengersInWorld(Entity entity, Level world) {
        if (world.m_7967_(entity) && entity.m_20160_()) {
            for (Entity passenger : entity.m_20197_()) {
                passenger.m_7678_(entity.m_20185_(), entity.m_20186_() + entity.m_6048_() + passenger.m_6049_(), entity.m_20189_(), passenger.m_146908_(), passenger.m_146909_());
                EntityUtils.setEntityRotations(passenger, passenger.m_146908_(), passenger.m_146909_());
                EntityUtils.spawnEntityAndPassengersInWorld(passenger, world);
            }
        }
    }

    public static void setEntityRotations(Entity entity, float yaw, float pitch) {
        entity.m_146922_(yaw);
        entity.f_19859_ = yaw;
        entity.m_146926_(pitch);
        entity.f_19860_ = pitch;
        if (entity instanceof LivingEntity) {
            LivingEntity livingBase = (LivingEntity)entity;
            livingBase.f_20885_ = yaw;
            livingBase.f_20883_ = yaw;
            livingBase.f_20886_ = yaw;
            livingBase.f_20884_ = yaw;
        }
    }

    public static List<Entity> getEntitiesWithinSubRegion(Level world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        BlockPos regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos posEndAbs = PositionUtils.getTransformedPlacementPosition(regionSize.m_7918_(-1, -1, -1), schematicPlacement, placement).m_121955_((Vec3i)regionPosRelTransformed).m_121955_((Vec3i)origin);
        BlockPos regionPosAbs = regionPosRelTransformed.m_121955_((Vec3i)origin);
        AABB bb = PositionUtils.createEnclosingAABB(regionPosAbs, posEndAbs);
        return world.m_6249_(null, bb, NOT_PLAYER);
    }

    public static boolean shouldPickBlock(Player player) {
        return Configs.Generic.PICK_BLOCK_ENABLED.getBooleanValue() && (!Configs.Generic.TOOL_ITEM_ENABLED.getBooleanValue() || !EntityUtils.hasToolItem((LivingEntity)player)) && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue();
    }
}

