/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import org.joml.Matrix4f;

public class LitematicaRenderer {
    private static final LitematicaRenderer INSTANCE = new LitematicaRenderer();
    private Minecraft mc;
    private WorldRendererSchematic worldRenderer;
    private Frustum frustum;
    private int frameCount;
    private long finishTimeNano;
    private boolean renderCollidingSchematicBlocks;
    private boolean renderPiecewiseSchematic;
    private boolean renderPiecewiseBlocks;

    private LitematicaRenderer() {
    }

    public static LitematicaRenderer getInstance() {
        return INSTANCE;
    }

    public WorldRendererSchematic getWorldRenderer() {
        if (this.worldRenderer == null) {
            this.mc = Minecraft.m_91087_();
            this.worldRenderer = new WorldRendererSchematic(this.mc);
        }
        return this.worldRenderer;
    }

    public void loadRenderers() {
        this.getWorldRenderer().loadRenderers();
    }

    public void onSchematicWorldChanged(@Nullable WorldSchematic worldClient) {
        this.getWorldRenderer().setWorldAndLoadRenderers(worldClient);
    }

    private void calculateFinishTime() {
        long fpsTarget = 60L;
        this.finishTimeNano = Configs.Generic.RENDER_THREAD_NO_TIMEOUT.getBooleanValue() ? Long.MAX_VALUE : System.nanoTime() + Math.max(1000000000L / fpsTarget / 2L, 0L);
    }

    public void renderSchematicOverlay(PoseStack matrices, Matrix4f projMatrix) {
        boolean invert = Hotkeys.INVERT_OVERLAY_RENDER_STATE.getKeybind().isKeybindHeld();
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() != invert) {
            boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
            float lineWidth = (float)(renderThrough ? Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH_THROUGH.getDoubleValue() : Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH.getDoubleValue());
            RenderSystem.disableCull();
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-0.4f, (float)-0.8f);
            RenderSystem.lineWidth((float)lineWidth);
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.getWorldRenderer().renderBlockOverlays(matrices, this.getCamera(), projMatrix);
            RenderSystem.enableDepthTest();
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.enableCull();
        }
    }

    public void piecewisePrepareAndUpdate(Frustum frustum) {
        boolean render = Configs.Generic.BETTER_RENDER_ORDER.getBooleanValue() && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && this.mc.m_91288_() != null;
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
        WorldRendererSchematic worldRenderer = this.getWorldRenderer();
        if (render && frustum != null && worldRenderer.hasWorld()) {
            boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
            this.renderPiecewiseSchematic = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() != invert;
            this.renderPiecewiseBlocks = this.renderPiecewiseSchematic && Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue();
            this.renderCollidingSchematicBlocks = Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue();
            if (this.renderPiecewiseSchematic) {
                this.mc.m_91307_().m_6180_("litematica_culling");
                this.calculateFinishTime();
                this.mc.m_91307_().m_6182_("litematica_terrain_setup");
                worldRenderer.setupTerrain(this.getCamera(), frustum, this.frameCount++, this.mc.f_91074_.m_5833_());
                this.mc.m_91307_().m_6182_("litematica_update_chunks");
                worldRenderer.updateChunks(this.finishTimeNano);
                this.mc.m_91307_().m_7238_();
                this.frustum = frustum;
            }
        }
    }

    public void piecewiseRenderSolid(PoseStack matrices, Matrix4f projMatrix) {
        if (this.renderPiecewiseBlocks) {
            this.mc.m_91307_().m_6180_("litematica_blocks_solid");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.getWorldRenderer().renderBlockLayer(RenderType.m_110451_(), matrices, this.getCamera(), projMatrix);
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.m_91307_().m_7238_();
        }
    }

    public void piecewiseRenderCutoutMipped(PoseStack matrices, Matrix4f projMatrix) {
        if (this.renderPiecewiseBlocks) {
            this.mc.m_91307_().m_6180_("litematica_blocks_cutout_mipped");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.getWorldRenderer().renderBlockLayer(RenderType.m_110457_(), matrices, this.getCamera(), projMatrix);
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.m_91307_().m_7238_();
        }
    }

    public void piecewiseRenderCutout(PoseStack matrices, Matrix4f projMatrix) {
        if (this.renderPiecewiseBlocks) {
            this.mc.m_91307_().m_6180_("litematica_blocks_cutout");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.getWorldRenderer().renderBlockLayer(RenderType.m_110463_(), matrices, this.getCamera(), projMatrix);
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.m_91307_().m_7238_();
        }
    }

    public void piecewiseRenderTranslucent(PoseStack matrices, Matrix4f projMatrix) {
        if (this.renderPiecewiseBlocks) {
            this.mc.m_91307_().m_6180_("litematica_translucent");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.getWorldRenderer().renderBlockLayer(RenderType.m_110466_(), matrices, this.getCamera(), projMatrix);
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.m_91307_().m_7238_();
        }
    }

    public void piecewiseRenderOverlay(PoseStack matrices, Matrix4f matrix4f) {
        if (this.renderPiecewiseSchematic) {
            RenderTarget fb;
            this.mc.m_91307_().m_6180_("litematica_overlay");
            RenderTarget renderTarget = fb = Minecraft.m_91085_() ? this.mc.f_91060_.m_109828_() : null;
            if (fb != null) {
                fb.m_83947_(false);
            }
            this.renderSchematicOverlay(matrices, matrix4f);
            if (fb != null) {
                this.mc.m_91385_().m_83947_(false);
            }
            this.mc.m_91307_().m_7238_();
        }
        this.cleanup();
    }

    public void piecewiseRenderEntities(PoseStack matrices, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.m_91307_().m_6180_("litematica_entities");
            this.getWorldRenderer().renderEntities(this.getCamera(), this.frustum, matrices, partialTicks);
            this.mc.m_91307_().m_7238_();
        }
    }

    private Camera getCamera() {
        return this.mc.f_91063_.m_109153_();
    }

    private void cleanup() {
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
    }
}

