/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class MixinWorldRenderer {
    @Shadow
    private ClientLevel f_109465_;

    @Inject(method={"reload()V"}, at={@At(value="RETURN")})
    private void onLoadRenderers(CallbackInfo ci) {
        if (this.f_109465_ != null && this.f_109465_ == Minecraft.m_91087_().f_91073_) {
            LitematicaRenderer.getInstance().loadRenderers();
        }
    }

    @Inject(method={"setupTerrain"}, at={@At(value="TAIL")})
    private void onPostSetupTerrain(Camera camera, Frustum frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        LitematicaRenderer.getInstance().piecewisePrepareAndUpdate(frustum);
    }

    @Inject(method={"renderLayer"}, at={@At(value="TAIL")})
    private void onRenderLayer(RenderType renderLayer, PoseStack matrixStack, double x, double y, double z, Matrix4f matrix4f, CallbackInfo ci) {
        if (renderLayer == RenderType.m_110451_()) {
            LitematicaRenderer.getInstance().piecewiseRenderSolid(matrixStack, matrix4f);
        } else if (renderLayer == RenderType.m_110457_()) {
            LitematicaRenderer.getInstance().piecewiseRenderCutoutMipped(matrixStack, matrix4f);
        } else if (renderLayer == RenderType.m_110463_()) {
            LitematicaRenderer.getInstance().piecewiseRenderCutout(matrixStack, matrix4f);
        } else if (renderLayer == RenderType.m_110466_()) {
            LitematicaRenderer.getInstance().piecewiseRenderTranslucent(matrixStack, matrix4f);
            LitematicaRenderer.getInstance().piecewiseRenderOverlay(matrixStack, matrix4f);
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE_STRING", args={"ldc=blockentities"}, target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V")})
    private void onPostRenderEntities(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        LitematicaRenderer.getInstance().piecewiseRenderEntities(matrices, tickDelta);
    }
}

