/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.repo;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV1DTO;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class FullDataSourceV1Repo
extends AbstractDhRepo<Long, FullDataSourceV1DTO> {
    public static final String TABLE_NAME = "Legacy_FullData_V1";

    public FullDataSourceV1Repo(String databaseType, File databaseFile) throws SQLException {
        super(databaseType, databaseFile, FullDataSourceV1DTO.class);
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String createWhereStatement(Long pos) {
        return "DhSectionPos = '" + FullDataSourceV1Repo.serializeSectionPos(pos) + "'";
    }

    @Override
    public FullDataSourceV1DTO convertDictionaryToDto(Map<String, Object> objectMap) throws ClassCastException {
        String posString = (String)objectMap.get("DhSectionPos");
        Long pos = FullDataSourceV1Repo.deserializeSectionPos(posString);
        int checksum = (Integer)objectMap.get("Checksum");
        byte dataDetailLevel = (Byte)objectMap.get("DataDetailLevel");
        String worldGenStepString = (String)objectMap.get("WorldGenStep");
        EDhApiWorldGenerationStep worldGenStep = EDhApiWorldGenerationStep.fromName(worldGenStepString);
        String dataType = (String)objectMap.get("DataType");
        byte binaryDataFormatVersion = (Byte)objectMap.get("BinaryDataFormatVersion");
        byte[] dataByteArray = (byte[])objectMap.get("Data");
        FullDataSourceV1DTO dto = new FullDataSourceV1DTO(pos, checksum, dataDetailLevel, worldGenStep, dataType, binaryDataFormatVersion, dataByteArray);
        return dto;
    }

    @Override
    public PreparedStatement createInsertStatement(FullDataSourceV1DTO dto) throws SQLException {
        String sql = "INSERT INTO " + this.getTableName() + "\n  (DhSectionPos, \nChecksum, DataVersion, DataDetailLevel, WorldGenStep, DataType, BinaryDataFormatVersion, \nData) \n   VALUES( \n    ? \n   ,? ,? ,? ,? ,? ,? \n   ,? \n);";
        PreparedStatement statement = this.createPreparedStatement(sql);
        int i = 1;
        statement.setObject(i++, FullDataSourceV1Repo.serializeSectionPos(dto.pos));
        statement.setObject(i++, dto.checksum);
        statement.setObject(i++, 0);
        statement.setObject(i++, dto.dataDetailLevel);
        statement.setObject(i++, (Object)dto.worldGenStep);
        statement.setObject(i++, dto.dataType);
        statement.setObject(i++, dto.binaryDataFormatVersion);
        statement.setObject(i++, dto.dataArray);
        return statement;
    }

    @Override
    public PreparedStatement createUpdateStatement(FullDataSourceV1DTO dto) throws SQLException {
        String sql = "UPDATE " + this.getTableName() + " \nSET \n    Checksum = ? \n   ,DataVersion = ? \n   ,DataDetailLevel = ? \n   ,WorldGenStep = ? \n   ,DataType = ? \n   ,BinaryDataFormatVersion = ? \n   ,Data = ? \n   ,LastModifiedDateTime = CURRENT_TIMESTAMP \nWHERE DhSectionPos = ?";
        PreparedStatement statement = this.createPreparedStatement(sql);
        int i = 1;
        statement.setObject(i++, dto.checksum);
        statement.setObject(i++, 0);
        statement.setObject(i++, dto.dataDetailLevel);
        statement.setObject(i++, (Object)dto.worldGenStep);
        statement.setObject(i++, dto.dataType);
        statement.setObject(i++, dto.binaryDataFormatVersion);
        statement.setObject(i++, dto.dataArray);
        statement.setObject(i++, FullDataSourceV1Repo.serializeSectionPos(dto.pos));
        return statement;
    }

    public int getMaxSectionDetailLevel() {
        Map<String, Object> resultMap = this.queryDictionaryFirst("select MAX(DataDetailLevel) as maxDetailLevel from " + this.getTableName() + ";");
        int maxDetailLevel = resultMap == null || resultMap.get("maxDetailLevel") == null ? 0 : (Integer)resultMap.get("maxDetailLevel");
        return maxDetailLevel + 6;
    }

    public long getMigrationCount() {
        Map<String, Object> resultMap = this.queryDictionaryFirst("select COUNT(*) as itemCount from " + this.getTableName() + " where MigrationFailed <> 1");
        if (resultMap == null) {
            return 0L;
        }
        Number resultNumber = (Number)resultMap.get("itemCount");
        long count = resultNumber.longValue();
        return count;
    }

    public LongArrayList getPositionsToMigrate(int returnCount) {
        LongArrayList list = new LongArrayList();
        List<Map<String, Object>> resultMapList = this.queryDictionary("select DhSectionPos from " + this.getTableName() + " WHERE MigrationFailed <> 1 LIMIT " + returnCount + ";");
        for (Map<String, Object> resultMap : resultMapList) {
            long sectionPos = FullDataSourceV1Repo.deserializeSectionPos((String)resultMap.get("DhSectionPos"));
            list.add(sectionPos);
        }
        return list;
    }

    public void markMigrationFailed(long pos) {
        String sql = "UPDATE " + this.getTableName() + " \nSET MigrationFailed = 1 \nWHERE DhSectionPos = '" + FullDataSourceV1Repo.serializeSectionPos(pos) + "'";
        this.queryDictionaryFirst(sql);
    }

    public long getUnusedDataSourceCount() {
        Map<String, Object> resultMap = this.queryDictionaryFirst("select Count(*) as unusedCount from " + this.getTableName() + " where DataDetailLevel <> 0 or DataType <> 'CompleteFullDataSource'");
        if (resultMap != null) {
            Number resultNumber = (Number)resultMap.get("unusedCount");
            long count = resultNumber.longValue();
            return count;
        }
        return 0L;
    }

    public ArrayList<String> getUnusedDataSourcePositionStringList(int deleteCount) {
        List<Map<String, Object>> deletePosResultMapList = this.queryDictionary("select DhSectionPos from " + this.getTableName() + " where DataDetailLevel <> 0 or DataType <> 'CompleteFullDataSource' limit " + deleteCount);
        ArrayList<String> deletePosList = new ArrayList<String>();
        for (Map<String, Object> deletePosMap : deletePosResultMapList) {
            String posString = (String)deletePosMap.get("DhSectionPos");
            deletePosList.add("'" + posString + "'");
        }
        return deletePosList;
    }

    public void deleteUnusedLegacyData(ArrayList<String> deletePosList) {
        String sectionPosCsv = StringUtil.join(",", deletePosList);
        this.queryDictionaryFirst("delete from " + this.getTableName() + " where DhSectionPos in (" + sectionPosCsv + ")");
    }

    private static String serializeSectionPos(long pos) {
        return "[" + DhSectionPos.getDetailLevel(pos) + ',' + DhSectionPos.getX(pos) + ',' + DhSectionPos.getZ(pos) + ']';
    }

    @Nullable
    private static Long deserializeSectionPos(String value) {
        if (value.charAt(0) != '[' || value.charAt(value.length() - 1) != ']') {
            return null;
        }
        String[] split = value.substring(1, value.length() - 1).split(",");
        if (split.length != 3) {
            return null;
        }
        return DhSectionPos.encode(Byte.parseByte(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
    }
}

