/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.subDimMatching;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.transformers.LodDataBuilder;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.structure.ClientOnlySaveStructure;
import com.seibel.distanthorizons.core.file.subDimMatching.SubDimCompare;
import com.seibel.distanthorizons.core.file.subDimMatching.SubDimensionPlayerData;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.DhClientLevel;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;

public class SubDimensionLevelMatcher
implements AutoCloseable {
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Client.Advanced.Logging.logFileSubDimEvent.get());
    private final ExecutorService matcherThread = ThreadUtil.makeSingleThreadPool("Sub Dimension Matcher");
    private SubDimensionPlayerData playerData = null;
    private SubDimensionPlayerData firstSeenPlayerData = null;
    private final AtomicBoolean determiningWorldFolder = new AtomicBoolean(false);
    private final IClientLevelWrapper currentClientLevel;
    private volatile File foundLevelFile = null;
    private final List<File> potentialLevelFolders;
    private final File levelsFolder;

    public SubDimensionLevelMatcher(IClientLevelWrapper targetLevel, File levelsFolder, List<File> potentialLevelFolders) {
        this.currentClientLevel = targetLevel;
        this.potentialLevelFolders = potentialLevelFolders;
        this.levelsFolder = levelsFolder;
        if (potentialLevelFolders.size() == 0) {
            String newId = UUID.randomUUID().toString();
            LOGGER.info("No potential level files found. Creating a new sub dimension with the ID [" + StringUtil.shortenString(newId, 8) + "]...", new Object[0]);
            this.foundLevelFile = this.CreateSubDimFolder(newId);
        }
    }

    public boolean isFindingLevel(ILevelWrapper level) {
        return Objects.equals(level, this.currentClientLevel);
    }

    public File tryGetLevel() {
        this.tryGetLevelInternalAsync();
        return this.foundLevelFile;
    }

    private void tryGetLevelInternalAsync() {
        if (this.foundLevelFile != null) {
            return;
        }
        if (this.determiningWorldFolder.getAndSet(true)) {
            return;
        }
        this.matcherThread.submit(() -> {
            try {
                File saveDir = this.attemptToDetermineSubDimensionFolder();
                if (saveDir != null) {
                    this.foundLevelFile = saveDir;
                }
            }
            catch (IOException e) {
                LOGGER.error("Unable to set the dimension file handler for level [" + this.currentClientLevel + "]. Error: ", e);
            }
            finally {
                this.determiningWorldFolder.set(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File attemptToDetermineSubDimensionFolder() throws IOException {
        IChunkWrapper newlyLoadedChunk;
        SubDimensionPlayerData newPlayerData = SubDimensionPlayerData.tryGetPlayerData(MC_CLIENT);
        if (newPlayerData != null) {
            if (this.firstSeenPlayerData == null) {
                this.firstSeenPlayerData = newPlayerData;
            }
            this.playerData = newPlayerData;
        }
        if ((newlyLoadedChunk = MC_CLIENT.getWrappedClientLevel().tryGetChunk(new DhChunkPos(this.playerData.playerBlockPos))) == null) {
            return null;
        }
        DhLightingEngine.INSTANCE.lightChunk(newlyLoadedChunk, new ArrayList<IChunkWrapper>(), MC_CLIENT.getWrappedClientLevel().hasSkyLight() ? 15 : 0);
        if (!LodDataBuilder.canGenerateLodFromChunk(newlyLoadedChunk)) {
            LOGGER.warn("unable to build lod for chunk:" + newlyLoadedChunk.getChunkPos(), new Object[0]);
            return null;
        }
        FullDataSourceV2 newChunkSizedFullDataView = FullDataSourceV2.createFromChunk(newlyLoadedChunk);
        FullDataSourceV2 newDataSource = FullDataSourceV2.createEmpty(DhSectionPos.encodeContaining((byte)6, this.playerData.playerBlockPos));
        newDataSource.update(newChunkSizedFullDataView);
        LOGGER.info("Attempting to determine sub-dimension for [" + MC_CLIENT.getWrappedClientLevel().getDimensionType().getDimensionName() + "]", new Object[0]);
        LOGGER.info("Player block pos in dimension: [" + this.playerData.playerBlockPos.getX() + "," + this.playerData.playerBlockPos.getY() + "," + this.playerData.playerBlockPos.getZ() + "]", new Object[0]);
        LOGGER.info("Potential Sub Dimension folders: [" + this.potentialLevelFolders.size() + "]", new Object[0]);
        SubDimCompare mostSimilarSubDim = null;
        for (File testLevelFolder : this.potentialLevelFolders) {
            LOGGER.info("Testing level folder: [" + StringUtil.shortenString(testLevelFolder.getName(), 8) + "]", new Object[0]);
            FullDataSourceV2 testFullDataSource = null;
            try {
                long testSectionChunkPos;
                DhClientLevel tempLevel = new DhClientLevel(new ClientOnlySaveStructure(), this.currentClientLevel, testLevelFolder, false);
                try {
                    testFullDataSource = (FullDataSourceV2)tempLevel.getFullDataProvider().getAsync(DhSectionPos.encodeContaining((byte)6, this.playerData.playerBlockPos)).join();
                    if (testFullDataSource == null) {
                        continue;
                    }
                }
                finally {
                    tempLevel.close();
                    continue;
                }
                long newSectionChunkPos = DhSectionPos.convertToDetailLevel(newDataSource.getPos(), (byte)10);
                LodUtil.assertTrue(newSectionChunkPos == (testSectionChunkPos = DhSectionPos.convertToDetailLevel(testFullDataSource.getPos(), (byte)10)), "data source positions don't match");
                int equalDataPoints = 0;
                int totalDataPointCount = 0;
                for (int x = 0; x < 64; ++x) {
                    for (int z = 0; z < 64; ++z) {
                        LongArrayList newColumn = newDataSource.get(x, z);
                        LongArrayList testColumn = testFullDataSource.get(x, z);
                        if (newColumn != null && testColumn != null) {
                            FullDataPointIdMap newDataMap = newDataSource.mapping;
                            FullDataPointIdMap testDataMap = testFullDataSource.mapping;
                            int minColumnIndex = Math.min(newColumn.size(), testColumn.size());
                            for (int i = 0; i < minColumnIndex; ++i) {
                                IBlockStateWrapper testBlock;
                                IBiomeWrapper testBiome;
                                int testHeight;
                                int testBottom;
                                long newDataPoint = newColumn.getLong(i);
                                long testDataPoint = testColumn.getLong(i);
                                int newId = FullDataPointUtil.getId(newDataPoint);
                                int testId = FullDataPointUtil.getId(testDataPoint);
                                int newBottom = FullDataPointUtil.getBottomY(newDataPoint);
                                if (newBottom == (testBottom = FullDataPointUtil.getBottomY(testDataPoint))) {
                                    ++equalDataPoints;
                                }
                                ++totalDataPointCount;
                                int newHeight = FullDataPointUtil.getHeight(newDataPoint);
                                if (newHeight == (testHeight = FullDataPointUtil.getHeight(testDataPoint))) {
                                    ++equalDataPoints;
                                }
                                ++totalDataPointCount;
                                IBiomeWrapper newBiome = newDataMap.getBiomeWrapper(newId);
                                if (newBiome.equals(testBiome = testDataMap.getBiomeWrapper(testId))) {
                                    ++equalDataPoints;
                                }
                                ++totalDataPointCount;
                                IBlockStateWrapper newBlock = newDataMap.getBlockStateWrapper(newId);
                                if (newBlock.equals(testBlock = testDataMap.getBlockStateWrapper(testId))) {
                                    ++equalDataPoints;
                                }
                                ++totalDataPointCount;
                            }
                            continue;
                        }
                        if (newColumn == null) continue;
                        totalDataPointCount += newColumn.size();
                    }
                }
                SubDimensionPlayerData testPlayerData = new SubDimensionPlayerData(testLevelFolder);
                LOGGER.info("Last known player pos: [" + testPlayerData.playerBlockPos.getX() + "," + testPlayerData.playerBlockPos.getY() + "," + testPlayerData.playerBlockPos.getZ() + "]", new Object[0]);
                int playerBlockDist = testPlayerData.playerBlockPos.getManhattanDistance(this.playerData.playerBlockPos);
                LOGGER.info("Player block position distance between saved sub dimension and first seen is [" + playerBlockDist + "]", new Object[0]);
                SubDimCompare subDimCompare = new SubDimCompare(equalDataPoints, totalDataPointCount, playerBlockDist, testLevelFolder);
                if (mostSimilarSubDim == null || subDimCompare.compareTo(mostSimilarSubDim) > 0) {
                    mostSimilarSubDim = subDimCompare;
                }
                String subDimShortName = StringUtil.shortenString(testLevelFolder.getName(), 8);
                String equalPercent = StringUtil.shortenString(mostSimilarSubDim.getPercentEqual() + "", 5);
                LOGGER.info("Sub dimension [" + subDimShortName + "...] is current dimension probability: " + equalPercent + " (" + equalDataPoints + "/" + totalDataPointCount + ")", new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warn("Error checking level: " + e.getMessage(), e);
            }
            finally {
                if (testFullDataSource == null) continue;
                try {
                    testFullDataSource.close();
                }
                catch (Exception e) {}
            }
        }
        this.firstSeenPlayerData = null;
        if (mostSimilarSubDim != null && mostSimilarSubDim.isValidSubDim()) {
            LOGGER.info("Sub Dimension set to: [" + StringUtil.shortenString(mostSimilarSubDim.folder.getName(), 8) + "...] with an equality of [" + mostSimilarSubDim.getPercentEqual() + "]", new Object[0]);
            return mostSimilarSubDim.folder;
        }
        String newId = UUID.randomUUID().toString();
        double highestEqualityPercent = mostSimilarSubDim != null ? mostSimilarSubDim.getPercentEqual() : 0.0;
        String message = "No suitable sub dimension found. The highest equality was [" + StringUtil.shortenString(highestEqualityPercent + "", 5) + "]. Creating a new sub dimension with ID: " + StringUtil.shortenString(newId, 8) + "...";
        LOGGER.info(message, new Object[0]);
        File folder = this.CreateSubDimFolder(newId);
        folder.mkdirs();
        return folder;
    }

    private File CreateSubDimFolder(String subDimId) {
        return new File(this.levelsFolder.getPath() + File.separatorChar + this.currentClientLevel.getDimensionType().getDimensionName(), subDimId);
    }

    @Override
    public void close() {
        this.matcherThread.shutdownNow();
    }
}

