/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file;

import com.seibel.distanthorizons.core.file.IDataSource;
import com.seibel.distanthorizons.core.level.IDhLevel;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class DataSourcePool<TDataSource extends IDataSource<TDhLevel>, TDhLevel extends IDhLevel> {
    private static final int MAX_POOLED_SOURCES = Runtime.getRuntime().availableProcessors() * 2;
    private final ArrayList<TDataSource> pooledDataSources = new ArrayList();
    private final ReentrantLock poolLock = new ReentrantLock();
    private final Function<Long, TDataSource> createEmptyDatasourceFunc;
    @Nullable
    private final IPrepPooledDataSourceFunc<TDataSource, TDhLevel> prepDatasourceFunc;

    public DataSourcePool(Function<Long, TDataSource> createEmptyDatasourceFunc, @Nullable IPrepPooledDataSourceFunc<TDataSource, TDhLevel> prepDatasourceFunc) {
        this.createEmptyDatasourceFunc = createEmptyDatasourceFunc;
        this.prepDatasourceFunc = prepDatasourceFunc;
    }

    public TDataSource getPooledSource(long pos) {
        return this.getPooledSource(pos, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDataSource getPooledSource(long pos, boolean clearData) {
        try {
            this.poolLock.lock();
            int index = this.pooledDataSources.size() - 1;
            if (index == -1) {
                IDataSource iDataSource = (IDataSource)this.createEmptyDatasourceFunc.apply(pos);
                return (TDataSource)iDataSource;
            }
            IDataSource dataSource = (IDataSource)this.pooledDataSources.remove(index);
            if (this.prepDatasourceFunc != null) {
                this.prepDatasourceFunc.prepDataSource(pos, clearData, dataSource);
            }
            IDataSource iDataSource = dataSource;
            return (TDataSource)iDataSource;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public void returnPooledDataSource(TDataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        if (this.pooledDataSources.size() > MAX_POOLED_SOURCES) {
            return;
        }
        try {
            this.poolLock.lock();
            this.pooledDataSources.add(dataSource);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public int size() {
        return this.pooledDataSources.size();
    }

    @FunctionalInterface
    public static interface IPrepPooledDataSourceFunc<TDataSource extends IDataSource<TDhLevel>, TDhLevel extends IDhLevel> {
        public void prepDataSource(long var1, boolean var3, TDataSource var4);
    }
}

