/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FullDataPointIdMap {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean RUN_SERIALIZATION_DUPLICATE_VALIDATION = false;
    private static final String BLOCK_STATE_SEPARATOR_STRING = "_DH-BSW_";
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private long pos;
    private final ArrayList<Entry> entryList = new ArrayList();
    private final HashMap<Entry, Integer> idMap = new HashMap();

    public FullDataPointIdMap(long pos) {
        this.pos = pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(int id) throws IndexOutOfBoundsException {
        try {
            Entry entry;
            this.readWriteLock.readLock().lock();
            try {
                entry = this.entryList.get(id);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException("FullData ID Map out of sync for pos: " + this.pos + ". ID: [" + id + "] greater than the number of known ID's: [" + this.entryList.size() + "].");
            }
            Entry entry2 = entry;
            return entry2;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public IBiomeWrapper getBiomeWrapper(int id) throws IndexOutOfBoundsException {
        return this.getEntry((int)id).biome;
    }

    public IBlockStateWrapper getBlockStateWrapper(int id) throws IndexOutOfBoundsException {
        return this.getEntry((int)id).blockState;
    }

    public int getMaxValidId() {
        return this.entryList.size() - 1;
    }

    public int size() {
        return this.entryList.size();
    }

    public boolean isEmpty() {
        return this.entryList.isEmpty();
    }

    public long getPos() {
        return this.pos;
    }

    public int addIfNotPresentAndGetId(IBiomeWrapper biome, IBlockStateWrapper blockState) {
        return this.addIfNotPresentAndGetId(Entry.getEntry(biome, blockState), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addIfNotPresentAndGetId(Entry biomeBlockStateEntry, boolean useWriteLocks) {
        try {
            int id;
            if (useWriteLocks) {
                this.readWriteLock.writeLock().lock();
            }
            if (this.idMap.containsKey(biomeBlockStateEntry)) {
                id = this.idMap.get(biomeBlockStateEntry);
            } else {
                id = this.entryList.size();
                this.entryList.add(biomeBlockStateEntry);
                this.idMap.put(biomeBlockStateEntry, id);
            }
            int n = id;
            return n;
        }
        finally {
            if (useWriteLocks) {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Entry biomeBlockStateEntry, boolean useWriteLocks) {
        try {
            if (useWriteLocks) {
                this.readWriteLock.writeLock().lock();
            }
            int id = this.entryList.size();
            this.entryList.add(biomeBlockStateEntry);
            this.idMap.put(biomeBlockStateEntry, id);
        }
        finally {
            if (useWriteLocks) {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(FullDataPointIdMap inputMap) {
        try {
            inputMap.readWriteLock.readLock().lock();
            this.readWriteLock.writeLock().lock();
            ArrayList<Entry> entriesToMerge = inputMap.entryList;
            for (int i = 0; i < entriesToMerge.size(); ++i) {
                Entry entity = entriesToMerge.get(i);
                this.add(entity, false);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
            inputMap.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] mergeAndReturnRemappedEntityIds(FullDataPointIdMap inputMap) {
        try {
            inputMap.readWriteLock.readLock().lock();
            this.readWriteLock.writeLock().lock();
            ArrayList<Entry> entriesToMerge = inputMap.entryList;
            int[] remappedEntryIds = new int[entriesToMerge.size()];
            for (int i = 0; i < entriesToMerge.size(); ++i) {
                int id;
                Entry entity = entriesToMerge.get(i);
                remappedEntryIds[i] = id = this.addIfNotPresentAndGetId(entity, false);
            }
            int[] nArray = remappedEntryIds;
            return nArray;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
            inputMap.readWriteLock.readLock().unlock();
        }
    }

    public void clear(long pos) {
        this.pos = pos;
        this.entryList.clear();
        this.idMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(DhDataOutputStream outputStream) throws IOException {
        try {
            this.readWriteLock.readLock().lock();
            outputStream.writeInt(this.entryList.size());
            HashMap dataPointEntryBySerialization = new HashMap();
            for (Entry entry : this.entryList) {
                String entryString = entry.serialize();
                outputStream.writeUTF(entryString);
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public static FullDataPointIdMap deserialize(DhDataInputStream inputStream, long pos, ILevelWrapper levelWrapper) throws IOException, InterruptedException, DataCorruptedException {
        int entityCount = inputStream.readInt();
        if (entityCount < 0) {
            throw new DataCorruptedException("FullDataPointIdMap deserialize entry count should have a number greater than or equal to 0, returned value [" + entityCount + "].");
        }
        HashMap dataPointEntryBySerialization = new HashMap();
        FullDataPointIdMap newMap = new FullDataPointIdMap(pos);
        for (int i = 0; i < entityCount; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException(FullDataPointIdMap.class.getSimpleName() + " task interrupted.");
            }
            String entryString = inputStream.readUTF();
            Entry newEntry = Entry.deserialize(entryString, levelWrapper);
            newMap.entryList.add(newEntry);
        }
        if (newMap.size() != entityCount) {
            LodUtil.assertNotReach("ID maps failed to deserialize for pos: [" + DhSectionPos.toString(pos) + "], incorrect entity count. Expected count [" + entityCount + "], actual count [" + newMap.size() + "]");
        }
        return newMap;
    }

    public boolean equals(Object other) {
        return other == this;
    }

    private static final class Entry {
        private static final IWrapperFactory WRAPPER_FACTORY = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
        private static final Int2ReferenceOpenHashMap<ArrayList<Entry>> ENTRY_POOL = new Int2ReferenceOpenHashMap();
        private static final ReentrantReadWriteLock ENTRY_POOL_LOCK = new ReentrantReadWriteLock();
        public final IBiomeWrapper biome;
        public final IBlockStateWrapper blockState;
        private Integer hashCode = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Entry getEntry(IBiomeWrapper biome, IBlockStateWrapper blockState) {
            ArrayList<Entry> entryList;
            int entryHash = Entry.getHashCode(biome, blockState);
            try {
                ENTRY_POOL_LOCK.readLock().lock();
                entryList = (ArrayList<Entry>)ENTRY_POOL.get(entryHash);
                if (entryList != null) {
                    for (int i = 0; i < entryList.size(); ++i) {
                        Entry entry = (Entry)entryList.get(i);
                        if (!entry.biome.equals(biome) || !entry.blockState.equals(blockState)) continue;
                        Entry entry2 = entry;
                        return entry2;
                    }
                }
            }
            finally {
                ENTRY_POOL_LOCK.readLock().unlock();
            }
            try {
                ENTRY_POOL_LOCK.writeLock().lock();
                entryList = (ArrayList)ENTRY_POOL.get(entryHash);
                if (entryList == null) {
                    entryList = new ArrayList<Entry>(1);
                    ENTRY_POOL.put(entryHash, entryList);
                }
                Entry newEntry = new Entry(biome, blockState);
                entryList.add(newEntry);
                Entry entry = newEntry;
                return entry;
            }
            finally {
                ENTRY_POOL_LOCK.writeLock().unlock();
            }
        }

        private Entry(IBiomeWrapper biome, IBlockStateWrapper blockState) {
            this.biome = biome;
            this.blockState = blockState;
        }

        public static int getHashCode(Entry entry) {
            return Entry.getHashCode(entry.biome, entry.blockState);
        }

        public static int getHashCode(IBiomeWrapper biome, IBlockStateWrapper blockState) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (biome == null ? 0 : biome.hashCode());
            result = 31 * result + (blockState == null ? 0 : blockState.hashCode());
            return result;
        }

        public int hashCode() {
            if (this.hashCode == null) {
                this.hashCode = Entry.getHashCode(this);
            }
            return this.hashCode;
        }

        public boolean equals(Object otherObj) {
            if (otherObj == this) {
                return true;
            }
            if (!(otherObj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)otherObj;
            return other.biome.getSerialString().equals(this.biome.getSerialString()) && other.blockState.getSerialString().equals(this.blockState.getSerialString());
        }

        public String toString() {
            return this.serialize();
        }

        public String serialize() {
            return this.biome.getSerialString() + FullDataPointIdMap.BLOCK_STATE_SEPARATOR_STRING + this.blockState.getSerialString();
        }

        public static Entry deserialize(String str, ILevelWrapper levelWrapper) throws IOException, DataCorruptedException {
            String[] stringArray = str.split(FullDataPointIdMap.BLOCK_STATE_SEPARATOR_STRING);
            if (stringArray.length != 2) {
                throw new DataCorruptedException("Failed to deserialize BiomeBlockStateEntry");
            }
            IBiomeWrapper biome = WRAPPER_FACTORY.deserializeBiomeWrapperOrGetDefault(stringArray[0], levelWrapper);
            IBlockStateWrapper blockState = WRAPPER_FACTORY.deserializeBlockStateWrapperOrGetDefault(stringArray[1], levelWrapper);
            return Entry.getEntry(biome, blockState);
        }
    }
}

