/*
 * Decompiled with CFR 0.152.
 */
package com.exline.exlinefurniture.sittable;

import com.exline.exlinefurniture.sittable.SittableEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class SitUtil {
    private static final Map<ResourceLocation, Map<BlockPos, Pair<SittableEntity, BlockPos>>> OCCUPIED = new HashMap<ResourceLocation, Map<BlockPos, Pair<SittableEntity, BlockPos>>>();

    public static boolean addSitEntity(Level world, BlockPos blockPos, SittableEntity entity, BlockPos playerPos) {
        if (!world.f_46443_) {
            ResourceLocation id = SitUtil.getDimensionTypeId(world);
            if (!OCCUPIED.containsKey(id)) {
                OCCUPIED.put(id, new HashMap());
            }
            OCCUPIED.get(id).put(blockPos, (Pair<SittableEntity, BlockPos>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static boolean removeSitEntity(Level world, BlockPos pos) {
        ResourceLocation id;
        if (!world.f_46443_ && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(world))) {
            OCCUPIED.get(id).remove(pos);
            return true;
        }
        return false;
    }

    public static SittableEntity getSitEntity(Level world, BlockPos pos) {
        ResourceLocation id;
        if (!world.f_46443_ && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(world)) && OCCUPIED.get(id).containsKey(pos)) {
            return (SittableEntity)((Object)OCCUPIED.get(id).get(pos).getLeft());
        }
        return null;
    }

    public static BlockPos getPreviousPlayerPosition(Player player, SittableEntity sitEntity) {
        ResourceLocation id;
        if (!player.m_9236_().f_46443_ && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(player.m_9236_()))) {
            for (Pair<SittableEntity, BlockPos> pair : OCCUPIED.get(id).values()) {
                if (pair.getLeft() != sitEntity) continue;
                return (BlockPos)pair.getRight();
            }
        }
        return null;
    }

    public static boolean isOccupied(Level world, BlockPos pos) {
        ResourceLocation id = SitUtil.getDimensionTypeId(world);
        return OCCUPIED.containsKey(id) && OCCUPIED.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(Player player) {
        for (ResourceLocation i : OCCUPIED.keySet()) {
            for (Pair<SittableEntity, BlockPos> pair : OCCUPIED.get(i).values()) {
                if (!((SittableEntity)((Object)pair.getLeft())).m_20363_((Entity)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static ResourceLocation getDimensionTypeId(Level world) {
        return world.m_46472_().m_135782_();
    }
}

