/*
 * Decompiled with CFR 0.152.
 */
package me.vierdant.playeremotes.config.file;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import me.vierdant.playeremotes.config.CommentedConfig;
import me.vierdant.playeremotes.config.Config;
import me.vierdant.playeremotes.config.UnmodifiableCommentedConfig;
import me.vierdant.playeremotes.config.UnmodifiableConfig;
import me.vierdant.playeremotes.config.concurrent.ConcurrentCommentedConfig;
import me.vierdant.playeremotes.config.concurrent.SynchronizedConfig;
import me.vierdant.playeremotes.config.file.AsyncFileConfig;
import me.vierdant.playeremotes.config.file.CommentedFileConfig;
import me.vierdant.playeremotes.config.file.ConfigLoadFilter;
import me.vierdant.playeremotes.config.file.FileNotFoundAction;
import me.vierdant.playeremotes.config.io.ConfigParser;
import me.vierdant.playeremotes.config.io.ConfigWriter;
import me.vierdant.playeremotes.config.io.ParsingMode;
import me.vierdant.playeremotes.config.io.WritingMode;
import me.vierdant.playeremotes.config.utils.ConcurrentCommentedConfigWrapper;

final class SyncFileConfig
extends ConcurrentCommentedConfigWrapper<SynchronizedConfig>
implements CommentedFileConfig {
    private final Path nioPath;
    private final Charset charset;
    private volatile boolean closed;
    private final ConfigWriter writer;
    private final WritingMode writingMode;
    private final ConfigParser<?> parser;
    private final FileNotFoundAction nefAction;
    private final ParsingMode parsingMode;
    private final ConfigLoadFilter reloadFilter;
    private final Runnable saveListener;
    private final Runnable loadListener;

    SyncFileConfig(SynchronizedConfig config, Path nioPath, Charset charset, ConfigWriter writer, WritingMode writingMode, ConfigParser<?> parser, ParsingMode parsingMode, FileNotFoundAction nefAction, ConfigLoadFilter reloadFilter, Runnable saveListener, Runnable loadListener) {
        super(config);
        this.nioPath = nioPath;
        this.charset = charset;
        this.writer = writer;
        this.parser = parser;
        this.parsingMode = parsingMode;
        this.nefAction = nefAction;
        this.writingMode = writingMode;
        this.reloadFilter = reloadFilter;
        this.saveListener = saveListener;
        this.loadListener = loadListener;
    }

    @Override
    public File getFile() {
        return this.nioPath.toFile();
    }

    @Override
    public Path getNioPath() {
        return this.nioPath;
    }

    @Override
    public void save() {
        if (this.closed) {
            throw new IllegalStateException("This FileConfig is closed, cannot save().");
        }
        ((SynchronizedConfig)this.config).bulkCommentedRead((? super UnmodifiableCommentedConfig config) -> this.writer.write((UnmodifiableConfig)config, this.nioPath, this.writingMode, this.charset));
        this.saveListener.run();
    }

    @Override
    public void load() {
        if (this.closed) {
            throw new IllegalStateException("This FileConfig is closed, cannot load().");
        }
        if (this.reloadFilter == null) {
            ((SynchronizedConfig)this.config).bulkCommentedUpdate((? super CommentedConfig view) -> this.parser.parse(this.nioPath, (Config)view, this.parsingMode, this.nefAction, this.charset));
        } else {
            Object newConfig = this.parser.parse(this.nioPath, this.nefAction, this.charset);
            CommentedConfig newCC = CommentedConfig.fake(newConfig);
            if (!this.reloadFilter.acceptNewVersion(newCC)) {
                return;
            }
            switch (this.parsingMode) {
                case REPLACE: {
                    ((SynchronizedConfig)this.config).replaceContentBy(newCC);
                    break;
                }
                default: {
                    AsyncFileConfig.putWithParsingMode(this.parsingMode, newCC, (ConcurrentCommentedConfig)this.config);
                }
            }
        }
        this.loadListener.run();
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

